/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.viewer.renderer.jfreechart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.resources.DataPackageResources;
import org.nuiton.math.matrix.MatrixND;

public class GraphMatrixNDDataset
extends AbstractSeriesDataset
implements CategoryDataset {
    private static final long serialVersionUID = -891382923646394164L;
    protected List<String> seriesNames;
    protected List<String> categoriesNames;
    protected MatrixND mat;

    public GraphMatrixNDDataset(MatrixND mat) {
        this(mat.getSemantic(1), mat.getSemantic(0), mat);
    }

    public GraphMatrixNDDataset(List<?> series, List<?> categories, MatrixND mat) {
        this.mat = mat;
        if (mat != null && mat.getDimCount() > 1) {
            String baseName = DataPackageResources.class.getCanonicalName();
            ResourceBundle resources = ResourceBundle.getBundle(baseName);
            int seriesCount = mat.getDim(1);
            if (seriesCount > 0) {
                if (series != null) {
                    if (series.size() != seriesCount) {
                        throw new IllegalArgumentException("DefaultCategoryDataset: the number of series names does not match the number of series in the data.");
                    }
                    this.seriesNames = new ArrayList<String>(seriesCount);
                    for (int i = 0; i < seriesCount; ++i) {
                        Object dim = mat.getSemantic(1).get(i);
                        this.seriesNames.add(dim.toString());
                    }
                } else {
                    String prefix = resources.getString("series.default-prefix") + " ";
                    this.seriesNames = this.generateNames(seriesCount, prefix);
                }
                int categoryCount = mat.getDim(0);
                if (categories != null) {
                    if (categories.size() != categoryCount) {
                        throw new IllegalArgumentException("DefaultCategoryDataset: the number of categories does not match the number of categories in the data.");
                    }
                    this.categoriesNames = new ArrayList<String>(categoryCount);
                    for (int i = 0; i < categoryCount; ++i) {
                        Object dim = mat.getSemantic(0).get(i);
                        this.categoriesNames.add(dim.toString());
                    }
                } else {
                    String prefix2 = resources.getString("categories.default-prefix") + " ";
                    this.categoriesNames = this.generateNames(categoryCount, prefix2);
                }
            } else {
                this.seriesNames = null;
                this.categoriesNames = null;
            }
        } else {
            this.seriesNames = null;
            this.categoriesNames = null;
        }
    }

    protected List<String> generateNames(int count, String prefix) {
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String name = prefix + (i + 1);
            result.add(name);
        }
        return result;
    }

    public int getSeriesCount() {
        int result = 0;
        if (this.mat != null && this.mat.getDimCount() > 1) {
            result = this.mat.getDim(1);
        }
        return result;
    }

    public Comparable getSeriesKey(int series) {
        return this.seriesNames.get(series).toString();
    }

    public int getColumnIndex(Comparable key) {
        return this.categoriesNames.indexOf(key);
    }

    public Comparable getColumnKey(int column) {
        return this.categoriesNames.get(column).toString();
    }

    public List getColumnKeys() {
        if (this.categoriesNames == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.categoriesNames);
    }

    public int getRowIndex(Comparable key) {
        return this.seriesNames.indexOf(key);
    }

    public Comparable getRowKey(int row) {
        return this.seriesNames.get(row).toString();
    }

    public List getRowKeys() {
        return this.seriesNames;
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return new Double(this.mat.getValue((Object)columnKey, (Object)rowKey));
    }

    public int getColumnCount() {
        return this.categoriesNames.size();
    }

    public int getRowCount() {
        return this.seriesNames.size();
    }

    public Number getValue(int row, int column) {
        Double result = new Double(this.mat.getValue(column, row));
        return result;
    }
}

