/*
 * #%L
 * 
 * 
 * $Id: SumAllAction.java 346 2011-04-07 12:26:45Z echatellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-matrix/tags/nuiton-matrix-2.3.2/nuiton-matrix-gui/src/main/java/org/nuiton/math/matrix/viewer/SumAllAction.java $
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix.viewer;

import javax.swing.Icon;

import org.nuiton.util.Resource;

/**
 * Sum all raw action.
 * 
 * Default matrix viewer panel action to sum all elements.
 * 
 * @author chatellier
 * @version $Revision: 346 $
 * 
 * Last update : $Date: 2011-04-07 14:26:45 +0200 (Thu, 07 Apr 2011) $
 * By : $Author: echatellier $
 */
public class SumAllAction implements MatrixDimensionAction {

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixGroupAction#getIcon()
     */
    @Override
    public Icon getIcon() {
        return Resource.getIcon("/icons/sigma-barre.gif");
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixGroupAction#getSelectedIcon()
     */
    @Override
    public Icon getSelectedIcon() {
        return Resource.getIcon("/icons/sigma.gif");
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixGroupAction#getDimensionIndex()
     */
    @Override
    public int getDimensionIndex() {
        return -1;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixGroupAction#getDimensionType()
     */
    @Override
    public Class<?> getDimensionType() {
        return null;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixGroupAction#getSumStep()
     */
    @Override
    public int getSumStep() {
        // sum all => -1
        return -1;
    }
}
