/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixTableModel;

public class MatrixTableModelND
extends AbstractTableModel
implements MatrixTableModel {
    private static final long serialVersionUID = 983978774901981167L;
    private static Log log = LogFactory.getLog(MatrixTableModelND.class);
    protected MatrixND m;
    protected int addRow = 0;
    protected int addCol = 0;
    protected int[] multRowCol = null;
    protected TableCellRenderer renderer = null;

    public MatrixTableModelND(MatrixND m) throws MatrixException {
        this.setMatrix(m);
    }

    @Override
    public MatrixND getMatrix() {
        return this.m;
    }

    @Override
    public void setMatrix(MatrixND m) {
        this.m = m;
        this.addRow = m.getDimCount() / 2;
        this.addCol = (m.getDimCount() + 1) / 2;
        this.multRowCol = new int[m.getDimCount()];
        for (int i = this.multRowCol.length - 1; i >= 0; --i) {
            this.multRowCol[i] = i >= this.multRowCol.length - 2 ? 1 : this.multRowCol[i + 2] * m.getDim(i + 2);
        }
    }

    protected int[] tableToMatrix(int row, int col) {
        int[] result = new int[this.m.getDimCount()];
        for (int i = 0; i < result.length; ++i) {
            int val = row;
            if (i % 2 == 1) {
                val = col;
            }
            result[i] = this.tableToMatrixCell(i, val);
        }
        return result;
    }

    protected int tableToMatrixCell(int dim, int tableValue) {
        int b = 0;
        int val = tableValue;
        if (dim % 2 == 1) {
            b = 1;
        }
        while (b < dim) {
            val %= this.multRowCol[b];
            b += 2;
        }
        int result = val / this.multRowCol[b];
        return result;
    }

    protected Object getValue(int row, int col) {
        Object result = null;
        result = row < this.addRow && col < this.addCol ? (row == this.addRow - 1 && col == this.addCol - 1 ? I18n._((String)this.m.getDimensionName(col * 2), (Object[])new Object[0]) + "\\" + I18n._((String)this.m.getDimensionName(row * 2 + 1), (Object[])new Object[0]) : (row == this.addRow - 1 ? I18n._((String)this.m.getDimensionName(col * 2), (Object[])new Object[0]) : (col == this.addCol - 1 ? I18n._((String)this.m.getDimensionName(row * 2 + 1), (Object[])new Object[0]) : ""))) : (row < this.addRow ? this.getSemantic(row * 2 + 1, this.tableToMatrixCell(row * 2 + 1, col - this.addCol)) : (col < this.addCol ? this.getSemantic(col * 2, this.tableToMatrixCell(col * 2, row - this.addRow)) : Double.valueOf(this.m.getValue(this.tableToMatrix(row - this.addRow, col - this.addCol)))));
        return result;
    }

    protected String getSemantic(int dim, int elem) {
        Object o = this.m.getSemantic(dim).get(elem);
        return o == null ? "" : o.toString();
    }

    @Override
    public String getColumnName(int column) {
        return null;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        result = this.m.getDimCount() != 1 ? this.multRowCol[0] * this.m.getDim(0) + this.addRow : 2;
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 0;
        result = this.m.getDimCount() != 1 ? this.multRowCol[1] * this.m.getDim(1) + this.addCol : this.m.getDim(0);
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        result = this.m.getDimCount() != 1 ? this.getValue(row, column) : this.getValue(column, row);
        return result;
    }

    @Override
    public void setValueAt(Object obj, int row, int column) {
        block3: {
            if (this.m.getDimCount() != 1 && row >= this.addRow && column >= this.addCol || this.m.getDimCount() == 1 && row >= 1) {
                try {
                    double val = Double.parseDouble((String)obj);
                    int[] coord = null;
                    coord = this.m.getDimCount() != 1 ? this.tableToMatrix(row - this.addRow, column - this.addCol) : new int[]{column};
                    this.m.setValue(coord, val);
                    this.fireTableDataChanged();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't convert value as double: " + obj), (Throwable)eee);
                }
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.m.getDimCount() != 1 && (row < this.addRow || column < this.addCol)) {
            return false;
        }
        return this.m.getDimCount() != 1 || row >= 1;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public TableCellRenderer getMatrixCellRenderer() {
        if (this.renderer == null) {
            this.renderer = new MatrixCellRenderer(this);
        }
        return this.renderer;
    }

    @Override
    public int getAdditionalRows() {
        return this.addRow;
    }

    @Override
    public int getAdditionalColumns() {
        return this.addCol;
    }

    public static class MatrixCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 6537813058357761914L;
        protected MatrixTableModelND model = null;
        protected Color bg = null;
        protected Color fg = null;
        protected Font font = null;
        protected Border border = null;

        public MatrixCellRenderer(MatrixTableModelND model) {
            this.model = model;
            this.bg = this.getBackground();
            this.fg = this.getForeground();
            this.font = this.getFont();
            this.border = this.getBorder();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(this.getText());
            if (this.model.m.getDimCount() != 1 && (row < this.model.addRow || column < this.model.addCol) || this.model.m.getDimCount() == 1 && row < 1) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
            } else {
                this.setBackground(this.bg);
                this.setForeground(this.fg);
                this.setFont(this.font);
                this.setBorder(this.border);
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

