package jaxx.runtime.swing;

/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ListToListSelector<B> extends ListSelector<B> {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENABLED = "add.enabled";
    public static final String BINDING_ADD_TOOL_TIP_TEXT = "add.toolTipText";
    public static final String BINDING_FROM_CELL_RENDERER = "from.cellRenderer";
    public static final String BINDING_FROM_MODEL = "from.model";
    public static final String BINDING_FROM_SELECTION_MODEL = "from.selectionModel";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_REMOVE_TOOL_TIP_TEXT = "remove.toolTipText";
    public static final String BINDING_TO_CELL_RENDERER = "to.cellRenderer";
    public static final String BINDING_TO_MODEL = "to.model";
    public static final String BINDING_TO_SELECTION_MODEL = "to.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Tz08TQRR+XWihUItYBQyQoGCMGlu9eKlRFCVKihrKgdiL0+4IS6Y748xbWC/GP8E/Qe9eTLx5Mh48e/Bi/BeM8eDVOLPb7rKyQJO6h93Ne+/73vd+vf0BWSXhzDbx/bL0XHTatLxya2PjYXObtvAOVS3pCOQSwidjgdWAUTuyK4T5Rs3AKx14ZYm3BXepuwddrcGIwueMqi1KEWE2iWgpValH7qovPNlljUSlsb7+9dN6Zb98YwH4Qqsb1qXMHYWKKxmsgeXYCCd0ph1SYcTd1DKk425qvceMbYkRpR6QNn0GL2CoBjlBpCZDONt7yQFHgPcFQnGh5iisU6a7y+UVhHMJvWpXZy+bkHW+N1CIgCKHkG1zmzKEhQNwXcSqCYthxaeSt+styRkTxKUIk6Y+vwNcCT2PtMfE5yPYoIEhjCeCTRrjH4vCBoit+1hKRN32ELmbpCsgjzUY23jSbyE3fyfNayqy5iRt850gfrITL2E6Ub/eoHK8QfGIMw3ISk+bEaYa+5duTbvCdZv6Z90MYeD9M1H6+uH7++XujhV07lOpoXtORM9eSC6oRMekHgsXzEOHVVaJqDYgrzpj0t6ZFGHdKWpxOl/Q/rKBl+8RtaUpskPfPn6aePJlAKxlGGGc2MvExN+HPG5J3QXObF/cXAwUFXaH9fu40aZH0KKMrVHXplLLg+J1myCZazqurad2w9etmElpRaSnmf/8u1R/t9htR0bLO31geNyS7GPIOS5zXBocXeeeUo9sVCjq2Ty+m7RLyphvSXQWfD54n0+rN7wX477oe+ZzKVBt/i73TFIMx+Vwd/U/sA06rfAwDuCY6IFjiLqkyajdJ80ocs7WHbFOfeyLypgvHMIw3RPD1b4ZrvXNUD2EYbYnhsW+Ge4ewfAXadr0orcHAAA=";
    private static final Log log = LogFactory.getLog(ListToListSelector.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected JList from;
    protected JScrollPane fromScrollpane;
    protected JButton remove;
    protected JList to;
    protected JScrollPane toScrollpane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListToListSelector<B> $ListSelector0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
        addPropertyChangeListener(PROPERTY_MODEL, new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
    
                Set<String> bindings = $bindings.keySet();
                JAXXUtil.applyDataBinding(ListToListSelector.this, bindings);
                JAXXUtil.processDataBinding(
                        ListToListSelector.this, bindings.toArray(new String[bindings.size()]));
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListToListSelector() {
        $initialize();
    }

    public ListToListSelector(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.add();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.remove();
    }

    public void doMouseClicked__on__from(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getClickCount()==2) { model.add(); }
    }

    public void doMouseClicked__on__to(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getClickCount()==2) { model.remove(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public JList getFrom() {
        return from;
    }

    public JScrollPane getFromScrollpane() {
        return fromScrollpane;
    }

    public JButton getRemove() {
        return remove;
    }

    public JList getTo() {
        return to;
    }

    public JScrollPane getToScrollpane() {
        return toScrollpane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFromScrollpane() {
        if (!allComponentsCreated) {
            return;
        }
        fromScrollpane.getViewport().add(from);
    }

    protected void addChildrenToToScrollpane() {
        if (!allComponentsCreated) {
            return;
        }
        toScrollpane.getViewport().add(to);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createFrom() {
        $objectMap.put("from", from = new JList());
        
        from.setName("from");
        from.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__from"));
    }

    protected void createFromScrollpane() {
        $objectMap.put("fromScrollpane", fromScrollpane = new JScrollPane());
        
        fromScrollpane.setName("fromScrollpane");
    }

    @Override
    protected void createModel() {
        $objectMap.put("model", model = new ListSelectorModel());
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createTo() {
        $objectMap.put("to", to = new JList());
        
        to.setName("to");
        to.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__to"));
    }

    protected void createToScrollpane() {
        $objectMap.put("toScrollpane", toScrollpane = new JScrollPane());
        
        toScrollpane.setName("toScrollpane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $ListSelector0
        add(fromScrollpane, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(add, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(toScrollpane, new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(remove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFromScrollpane();
        addChildrenToToScrollpane();
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        add.setIcon(SwingUtil.createActionIcon("select"));
        remove.setIcon(SwingUtil.createActionIcon("unselect"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$ListSelector0", $ListSelector0);
        createFromScrollpane();
        createFrom();
        createAdd();
        createToScrollpane();
        createTo();
        createRemove();
        // inline creation of $ListSelector0
        setName("$ListSelector0");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FROM_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                from.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fromModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    from.setModel(getModel().getFromModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fromModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fromModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    from.setSelectionModel(getModel().getFromModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fromModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("addEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    add.setEnabled(getModel().isAddEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("addEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_TOOL_TIP_TEXT, true ,"addToolTip") {
        
            @Override
            public void processDataBinding() {
                add.setToolTipText(t(getAddToolTip()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TO_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                to.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setSelectionModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    remove.setEnabled(getModel().isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TOOL_TIP_TEXT, true ,"removeToolTip") {
        
            @Override
            public void processDataBinding() {
                remove.setToolTipText(t(getRemoveToolTip()));
            }
        });
    }

}