package jaxx.runtime.swing;

/*
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ComboToListSelector<B> extends ListSelector<B> {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENABLED = "add.enabled";
    public static final String BINDING_ADD_TOOL_TIP_TEXT = "add.toolTipText";
    public static final String BINDING_FROM_MODEL = "from.model";
    public static final String BINDING_FROM_RENDERER = "from.renderer";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_REMOVE_TOOL_TIP_TEXT = "remove.toolTipText";
    public static final String BINDING_TO_CELL_RENDERER = "to.cellRenderer";
    public static final String BINDING_TO_MODEL = "to.model";
    public static final String BINDING_TO_SELECTION_MODEL = "to.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVO28TQRAeO/ErL0JMXhBQgICEIDYtShRCgqIQORDFLiLcsPZtkovWt8veXHJQIH4CPwF6GiQ6KkRBTUGD+AsIUdAiZs/PgwuxsIuztfPNN9/MfnN+/Q0SroaLB8z3c9pz0K7x3MadnZ0HlQNexbvcrWpbodRQ/8TiEC/DoNU6dxEulwsmPd9Iz6/KmpIOdzqyFwow4OITwd19zhHhfDij6rr5Yiu84CtPN1lboqJYX/74Hn9hPX8VB/AVqUtTK7MnZbU76S9A3LYQxqjSIcsL5uyRDG07e6R32JytCua691mNP4ZnkCpAUjFNZAiXum854AjyfYUwMlewXSxyQdOV+ibC1ZBe94iqG9UVWZKdSKUCjiRCoiYtLhDmIhI7MzYNrJ3Wv6tlDWHctOU34BtBoRXpG0ymBU2xKtrSoas9E0KXpBQrTIfBfcyiEWZDwBUPUToGMNbCJTWvycNgkJPhSFqQ6i3mcITJEE2xqqUQJhIuGUeJcDoENY2b6FlFFjgXmgyZK9c2V/v2Y2VIaI+OEabKf/txm0J1J0794URDGER/TWQ/v/v6dq1pv2GqPR4J7dgesoXSUnGNtil9qu49D22R32RqoQwZt3GBFJ2JENa8XxJH9YIx5Ex6bp25+0SRSH15/2Hi0ac+iK/BgJDMWmMGfw8yuK9pClJYvrq9HCgaOkrTc9RoaztrZNFiyGYrtmPRcJd8msFMxAxaQiqZjz+zxTfLzTnESNf0sfD2LBIPIWk7wnZ4sIiNHYtcvEHlcs+S7V2K2q6Y+R5VDc9fCZ7XohpN0xJbXPPAyjd8z3zNB8LNr3zXPJldGi+yiiBfjS3WW5llSK+Qiod8KZo42wVxv12t788x4ia64EhxxyizeqQZRNr6kq1K3MeeqMzx0j8YprtiWO2ZYb0nBoShKhdi+2QDXejKQNLBedd+Gvj81v8SmePrPUoZqb926L0f/HGcwPYbEb6jQzgIAAA=";
    private static final Log log = LogFactory.getLog(ComboToListSelector.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actions;
    protected JButton add;
    protected JComboBox from;
    protected JScrollPane listPane;
    protected JButton remove;
    protected JList to;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ComboToListSelector<B> $ListSelector0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
        addPropertyChangeListener(PROPERTY_MODEL, new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
    
                Set<String> bindings = $bindings.keySet();
                JAXXUtil.applyDataBinding(ComboToListSelector.this, bindings);
                JAXXUtil.processDataBinding(
                        ComboToListSelector.this, bindings.toArray(new String[bindings.size()]));
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ComboToListSelector() {
        $initialize();
    }

    public ComboToListSelector(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.add();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.remove();
    }

    public void doMouseClicked__on__to(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getClickCount()==2) { model.remove(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActions() {
        return actions;
    }

    public JButton getAdd() {
        return add;
    }

    public JComboBox getFrom() {
        return from;
    }

    public JScrollPane getListPane() {
        return listPane;
    }

    public JButton getRemove() {
        return remove;
    }

    public JList getTo() {
        return to;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActions() {
        if (!allComponentsCreated) {
            return;
        }
        actions.add(add);
        actions.add(remove);
    }

    protected void addChildrenToListPane() {
        if (!allComponentsCreated) {
            return;
        }
        listPane.getViewport().add(to);
    }

    protected void createActions() {
        $objectMap.put("actions", actions = new JToolBar());
        
        actions.setName("actions");
        actions.setFloatable(false);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createFrom() {
        $objectMap.put("from", from = new JComboBox());
        
        from.setName("from");
    }

    protected void createListPane() {
        $objectMap.put("listPane", listPane = new JScrollPane());
        
        listPane.setName("listPane");
    }

    @Override
    protected void createModel() {
        $objectMap.put("model", model = new ListSelectorModel());
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createTo() {
        $objectMap.put("to", to = new JList());
        
        to.setName("to");
        if (to.getFont() != null) {
            to.setFont(to.getFont().deriveFont((float) 11));
        }
        to.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__to"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $ListSelector0
        add(from, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(actions, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(listPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToActions();
        addChildrenToListPane();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        add.setIcon(SwingUtil.createActionIcon("add"));
        remove.setIcon(SwingUtil.createActionIcon("remove"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$ListSelector0", $ListSelector0);
        createFrom();
        createActions();
        createAdd();
        createRemove();
        createListPane();
        createTo();
        // inline creation of $ListSelector0
        setName("$ListSelector0");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fromModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    from.setModel(getModel().getFromModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fromModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FROM_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                from.setRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("addEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    add.setEnabled(getModel().isAddEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("addEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_TOOL_TIP_TEXT, true ,"addToolTip") {
        
            @Override
            public void processDataBinding() {
                add.setToolTipText(t(getAddToolTip()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    remove.setEnabled(getModel().isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TOOL_TIP_TEXT, true ,"removeToolTip") {
        
            @Override
            public void processDataBinding() {
                remove.setToolTipText(t(getRemoveToolTip()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TO_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                to.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setSelectionModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
    }

}