package jaxx.runtime.swing;

import java.awt.*;
import java.awt.event.*;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class MemoryStatusWidget extends javax.swing.JComponent implements java.awt.event.ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PROGRESS_BACKGROUND = "progressBackground";
    public static final String PROPERTY_PROGRESS_FOREGROUND = "progressForeground";
    public static final String PROPERTY_TIMER = "timer";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JCOMPONENT0_FONT = "$JComponent0.font";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdX2IHO+EjsbCCCCiEJKI6Q20EgSCLRA5IGIkIN6x9G3vD+W7ZncMXCsRP4CdAT4NER4UoqCloEH8BIQpaxOz642JyhFxxd9p58+bN7Js33yGrFVzYZXHsqihA0eXu5o3t7bvNXd7CW1y3lJAYKug/GQecBkx7o3ONcLFRM+nlQXp5PezKMODBvuxKDQoa93yuO5wjwrnxjJbW5fooXIllpIasI1FprK9+/nBeei9eOwCxJHU5amXxf1lJJ5M1cISHMEeVnrKyz4I2yVAiaJPe4+Zs3Wda32Fd/gSew1QNcpIpIkNYOnrLlsPmxxJhZnlzBL6MsDKmVveotrvFu6HaqyPDSD8QXpujlJYgh5A1OIUwa9TFg4T75izBzEkVthXX+iZrPW6rMAqoxxMmwWU9pJH4YRq6GireR5vIbIIoLtdtTxuBQMF88YwrUr5qlbeoF+Fz5fbbdg8gD6W5YkIlgig4OzYIMoSbGCK5sUwDsiqiY4T5xkEP3aNQ3z3zf7nHENro71Lxy/tv76pDy0xQ7dOp0H2Op6ukKUkavDClT/b9EqHwy1tMVhqQ19yndbHrsJAirD4IkziqZy/PNenubaY7RJGd+vrhY+nR5wlwqlDwQ+ZVmcFvQB47dDmd0PdieX3NKprpHaP3KaMNodDcf8lXPYZssSkCj3xxLaZBLKQMYqSmmf/0q1h/uzYcRobEnfknPBlI9iHkROCLgNsNGixH6sZMS80jL0yWIG0tMuZbkAOvnLfvpbRuJ3fCAE10JY7MZ9WKNn+XjsxR2Bkz+iFMfwC6eOBlHQUAAA==";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.MemoryStatusWidget.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.awt.Color progressBackground;
    protected java.awt.Color progressForeground;
    protected javax.swing.Timer timer;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MemoryStatusWidget $JComponent0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private final static String memoryTestStr = "99999/99999Mb";
    private FontRenderContext frc;
    private LineMetrics lm;
    
    
    @Override
    public void actionPerformed(ActionEvent evt) {
        repaint();
    }
    
    /** Adds a feature to the Notify attribute of the MemoryStatus object */
    @Override
    public void addNotify() {
        super.addNotify();
        setTimer(new javax.swing.Timer(2000, this));
        timer.start();
    }
    
    @Override
    public void removeNotify() {
        if (timer != null) {
            timer.stop();
            timer = null;
        }
        super.removeNotify();
    }
    
    @Override
    public void paintComponent(Graphics g) {
        Insets insets = new Insets(0, 0, 0, 0);
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int) (runtime.freeMemory() / 1024L);
        int totalMemory = (int) (runtime.totalMemory() / 1024L);
        int usedMemory = totalMemory - freeMemory;
        int width = getWidth() - insets.left - insets.right;
        int height = getHeight() - insets.top - insets.bottom - 1;
        float fraction = (float) usedMemory / (float) totalMemory;
        g.setColor(progressBackground);
        g.fillRect(insets.left, insets.top, (int) ((float) width * fraction), height);
        // No i18n string was :
        // String str = usedMemory / 1024 + "/" + totalMemory / 1024 + "Mb";
        String str = _("memorywidget.memory", usedMemory / 1024, totalMemory / 1024);
        //FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D bounds = g.getFont().getStringBounds(str, frc);
        Graphics g2 = g.create();
        g2.setClip(insets.left, insets.top,
                (int) ((float) width * fraction), height);
        g2.setColor(progressForeground);
        g2.drawString(str, insets.left
                + (int) ((double) width - bounds.getWidth()) / 2,
                (int) ((float) insets.top + lm.getAscent()));
        g2.dispose();
        g2 = g.create();
        g2.setClip(insets.left + (int) ((float) width * fraction),
                insets.top, getWidth() - insets.left
                        - (int) ((float) width * fraction), height);
        g2.setColor(getForeground());
        g2.drawString(str, insets.left
                + (int) ((double) width - bounds.getWidth()) / 2,
                (int) ((float) insets.top + lm.getAscent()));
        g2.dispose();
    }
    
    
    void $afterCompleteSetup() {
        //FontRenderContext frc = new FontRenderContext(null, false, false);
        Rectangle2D bounds = getFont().getStringBounds(memoryTestStr, frc);
        Dimension dim = new Dimension((int) bounds.getWidth(), (int) bounds .getHeight());
        setPreferredSize(dim);
        setMaximumSize(dim);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MemoryStatusWidget() {
        $initialize();
    }

    public MemoryStatusWidget(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.awt.Color getProgressBackground() {
        return progressBackground;
    }

    public java.awt.Color getProgressForeground() {
        return progressForeground;
    }

    public javax.swing.Timer getTimer() {
        return timer;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProgressBackground(java.awt.Color newValue) {
        java.awt.Color oldValue = this.progressBackground;
        this.progressBackground = newValue;
        firePropertyChange(PROPERTY_PROGRESS_BACKGROUND, oldValue, newValue);
    }

    public void setProgressForeground(java.awt.Color newValue) {
        java.awt.Color oldValue = this.progressForeground;
        this.progressForeground = newValue;
        firePropertyChange(PROPERTY_PROGRESS_FOREGROUND, oldValue, newValue);
    }

    public void setTimer(javax.swing.Timer newValue) {
        javax.swing.Timer oldValue = this.timer;
        this.timer = newValue;
        firePropertyChange(PROPERTY_TIMER, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createProgressBackground() {
        $objectMap.put("progressBackground", progressBackground = Color.decode("#666699a"));
    }

    protected void createProgressForeground() {
        $objectMap.put("progressForeground", progressForeground = Color.decode("#cccccc"));
    }

    protected void createTimer() {
        $objectMap.put("timer", timer = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        setBackground(Color.WHITE);
        setForeground(Color.BLACK);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JComponent0", this);
        createTimer();
        createProgressBackground();
        createProgressForeground();
        frc = new FontRenderContext(null, false, false);
        lm = new JLabel().getFont().getLineMetrics(memoryTestStr, frc);
        // inline creation of $JComponent0
        setName("$JComponent0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JCOMPONENT0_FONT, true) {
        
            @Override
            public void applyDataBinding() {
                if (new JLabel() != null) {
                    new JLabel().addPropertyChangeListener("font", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (new JLabel() != null) {
                    setFont(new JLabel().getFont());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (new JLabel() != null) {
                    new JLabel().removePropertyChangeListener("font", this);
                }
            }
        });
    }

}