/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.absolute;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import org.nuiton.jaxx.widgets.gis.CoordinateHelper;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteCoordinateEditorModel;

public class CoordinatesEditorModel
extends AbstractSerializableBean {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_LATITUDE = "latitude";
    public static final String PROPERTY_LONGITUDE = "longitude";
    public static final String PROPERTY_QUADRANT = "quadrant";
    public static final String PROPERTY_FORMAT = "format";
    public static final String PROPERTY_SHOW_RESET_BUTTON = "showResetButton";
    public static final String PROPERTY_DISPLAY_ZERO_WHEN_NULL = "displayZeroWhenNull";
    protected final AbsoluteCoordinateEditorModel latitudeModel = new AbsoluteCoordinateEditorModel();
    protected final AbsoluteCoordinateEditorModel longitudeModel = new AbsoluteCoordinateEditorModel();
    protected Serializable bean;
    protected String propertyLatitude;
    protected String propertyLongitude;
    protected String propertyQuadrant;
    protected Integer quadrant;
    protected CoordinateFormat format;
    protected boolean showResetButton;
    protected boolean displayZeroWhenNull;
    private boolean valueIsAdjusting;

    public CoordinatesEditorModel() {
        this.latitudeModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!CoordinatesEditorModel.this.valueIsAdjusting) {
                    CoordinatesEditorModel.this.fireLatitude();
                }
            }
        });
        this.longitudeModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!CoordinatesEditorModel.this.valueIsAdjusting) {
                    CoordinatesEditorModel.this.fireLongitude();
                }
            }
        });
        this.addPropertyChangeListener(PROPERTY_QUADRANT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CoordinatesEditorModel.this.fireLatitude();
                CoordinatesEditorModel.this.fireLongitude();
            }
        });
        this.addPropertyChangeListener(PROPERTY_FORMAT, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CoordinatesEditorModel.this.valueIsAdjusting = true;
                try {
                    CoordinateFormat oldFormat = (CoordinateFormat)((Object)evt.getOldValue());
                    if (oldFormat != null) {
                        Float latitude = CoordinatesEditorModel.this.latitudeModel.getValue(oldFormat);
                        CoordinatesEditorModel.this.latitudeModel.setValue(latitude);
                        Float longitude = CoordinatesEditorModel.this.longitudeModel.getValue(oldFormat);
                        CoordinatesEditorModel.this.longitudeModel.setValue(longitude);
                    }
                }
                finally {
                    CoordinatesEditorModel.this.valueIsAdjusting = false;
                    CoordinatesEditorModel.this.fireLatitude();
                    CoordinatesEditorModel.this.fireLongitude();
                }
            }
        });
    }

    public Serializable getBean() {
        return this.bean;
    }

    public void setBean(Serializable bean) {
        this.bean = bean;
    }

    public String getPropertyLatitude() {
        return this.propertyLatitude;
    }

    public void setPropertyLatitude(String propertyLatitude) {
        this.propertyLatitude = propertyLatitude;
    }

    public String getPropertyLongitude() {
        return this.propertyLongitude;
    }

    public void setPropertyLongitude(String propertyLongitude) {
        this.propertyLongitude = propertyLongitude;
    }

    public String getPropertyQuadrant() {
        return this.propertyQuadrant;
    }

    public void setPropertyQuadrant(String propertyQuadrant) {
        this.propertyQuadrant = propertyQuadrant;
    }

    public boolean isDisplayZeroWhenNull() {
        return this.displayZeroWhenNull;
    }

    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) {
        boolean oldValue = this.isDisplayZeroWhenNull();
        this.displayZeroWhenNull = displayZeroWhenNull;
        this.firePropertyChange(PROPERTY_DISPLAY_ZERO_WHEN_NULL, oldValue, displayZeroWhenNull);
    }

    public boolean isShowResetButton() {
        return this.showResetButton;
    }

    public void setShowResetButton(boolean showResetButton) {
        boolean oldValue = this.isShowResetButton();
        this.showResetButton = showResetButton;
        this.firePropertyChange(PROPERTY_SHOW_RESET_BUTTON, oldValue, showResetButton);
    }

    public AbsoluteCoordinateEditorModel getLatitudeModel() {
        return this.latitudeModel;
    }

    public AbsoluteCoordinateEditorModel getLongitudeModel() {
        return this.longitudeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLatitudeAndLongitude(Float latitude, Float longitude) {
        this.valueIsAdjusting = true;
        Integer newQuadrant = CoordinateHelper.getQuadrant(longitude, latitude);
        boolean quadrantChanged = newQuadrant != null;
        try {
            if (quadrantChanged) {
                this.quadrant = newQuadrant;
            }
            this.latitudeModel.setValue(latitude);
            this.longitudeModel.setValue(longitude);
        }
        finally {
            this.valueIsAdjusting = false;
            this.fireLatitude();
            this.fireLongitude();
            if (quadrantChanged) {
                this.fireQuadrant();
            }
        }
    }

    public Float getLatitude() {
        Float latitude;
        if (this.format == null) {
            latitude = null;
        } else {
            Float absoluteLatitude = this.latitudeModel.getValue(this.format);
            latitude = CoordinateHelper.getSignedLatitude(this.quadrant, absoluteLatitude);
        }
        return latitude;
    }

    public void setLatitude(Float latitude) {
        this.valueIsAdjusting = true;
        try {
            this.latitudeModel.setValue(latitude);
        }
        finally {
            this.valueIsAdjusting = false;
            this.fireLatitude();
        }
    }

    public Float getLongitude() {
        Float longitude;
        if (this.format == null) {
            longitude = null;
        } else {
            Float absoluteLongitude = this.longitudeModel.getValue(this.format);
            longitude = CoordinateHelper.getSignedLongitude(this.quadrant, absoluteLongitude);
        }
        return longitude;
    }

    public void setLongitude(Float longitude) {
        this.valueIsAdjusting = true;
        try {
            this.longitudeModel.setValue(longitude);
        }
        finally {
            this.valueIsAdjusting = false;
            this.fireLongitude();
        }
    }

    public Integer getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(Integer quadrant) {
        Integer oldValue = this.getQuadrant();
        this.quadrant = quadrant;
        this.firePropertyChange(PROPERTY_QUADRANT, oldValue, quadrant);
    }

    public CoordinateFormat getFormat() {
        return this.format;
    }

    public void setFormat(CoordinateFormat format) {
        CoordinateFormat oldValue = this.getFormat();
        this.format = format;
        this.firePropertyChange(PROPERTY_FORMAT, (Object)oldValue, (Object)format);
    }

    protected void fireLatitude() {
        this.firePropertyChange(PROPERTY_LATITUDE, null, this.getLatitude());
    }

    protected void fireLongitude() {
        this.firePropertyChange(PROPERTY_LONGITUDE, null, this.getLongitude());
    }

    protected void fireQuadrant() {
        this.firePropertyChange(PROPERTY_QUADRANT, null, this.getQuadrant());
    }

    protected void updateFormat(CoordinateFormat format) {
        if (format != null) {
            Float latitude = this.latitudeModel.getValue(format);
            this.latitudeModel.setValue(latitude);
            Float longitude = this.longitudeModel.getValue(format);
            this.longitudeModel.setValue(longitude);
        }
    }
}

