/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

class TimeSliderInitializer {
    TimeSliderInitializer() {
    }

    public void init(JSlider slider) {
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < 25; i += 2) {
            labelTable.put(i * 60, new JLabel(i + ""));
        }
        slider.setLabelTable(labelTable);
        slider.addMouseListener(new MouseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                JSlider component = (JSlider)e.getComponent();
                if (component.isEnabled()) {
                    component.setValueIsAdjusting(true);
                    try {
                        int value = TimeSliderInitializer.this.getSliderValue(e);
                        component.setValue(value);
                    }
                    finally {
                        component.setValueIsAdjusting(false);
                    }
                }
                TimeSliderInitializer.this.showToolTip(e);
                e.consume();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TimeSliderInitializer.this.showToolTip(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TimeSliderInitializer.this.showToolTip(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        slider.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TimeSliderInitializer.this.showToolTip(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TimeSliderInitializer.this.showToolTip(e);
            }
        });
        slider.addMouseWheelListener(new MouseWheelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JSlider component = (JSlider)e.getComponent();
                if (component.isEnabled()) {
                    int nb = e.getWheelRotation();
                    int value = component.getValue() - nb;
                    component.setValueIsAdjusting(true);
                    try {
                        component.setValue(value);
                    }
                    finally {
                        component.setValueIsAdjusting(false);
                    }
                }
                e.consume();
            }
        });
    }

    int getSliderValue(MouseEvent e) {
        JSlider slider = (JSlider)e.getSource();
        int value = -1;
        if (slider.getUI() instanceof BasicSliderUI) {
            BasicSliderUI ui = (BasicSliderUI)slider.getUI();
            value = slider.getOrientation() == 0 ? ui.valueForXPosition(e.getX()) : ui.valueForYPosition(e.getY());
        }
        return value;
    }

    void showToolTip(MouseEvent e) {
        int value = this.getSliderValue(e);
        if (value == -1) {
            return;
        }
        int h = value / 60;
        int m = value % 60;
        String text = "";
        if (h < 10) {
            text = "0";
        }
        text = text + h + " : ";
        if (m < 10) {
            text = text + "0";
        }
        text = text + m;
        JSlider source = (JSlider)e.getSource();
        source.setToolTipText(text);
    }
}

