package jaxx.runtime.swing.session;

/*
 * #%L
 * JAXX :: Runtime
 * $Id: JTableState.java 2650 2013-04-07 10:33:20Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.17/jaxx-runtime/src/main/java/jaxx/runtime/swing/session/JTableState.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import javax.swing.*;
import javax.swing.table.TableColumn;

/**
 * State for JTable.
 * TODO add support for column order change
 *
 * @author poussin
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.5.16
 *
 */
public class JTableState implements State {

    protected int[] columnWidths = new int[0];

    public JTableState() {
    }

    public JTableState(int[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    public int[] getColumnWidths() {
        return columnWidths;
    }

    public void setColumnWidths(int[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    protected JTable checkComponent(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(o instanceof JTable)) {
            throw new IllegalArgumentException("invalid component");
        }
        return (JTable) o;
    }

    @Override
    public State getState(Object o) {
        JTable table = checkComponent(o);
        int[] columnWidths = new int[table.getColumnCount()];
        boolean resizableColumnExists = false;
        for (int i = 0; i < columnWidths.length; i++) {
            TableColumn tc = table.getColumnModel().getColumn(i);
            columnWidths[i] = (tc.getResizable()) ? tc.getWidth() : -1;
            if (tc.getResizable()) {
                resizableColumnExists = true;
            }
        }
        JTableState result = null;
        if (resizableColumnExists) {
            result = new JTableState();
            result.setColumnWidths(columnWidths);
        }
        return result;
    }

    @Override
    public void setState(Object o, State state) {
        if (!(state instanceof JTableState)) {
            throw new IllegalArgumentException("invalid state");
        }
        JTable table = checkComponent(o);
        int[] columnWidths = ((JTableState) state).getColumnWidths();
        if (columnWidths != null
                && table.getColumnCount() == columnWidths.length) {
            for (int i = 0; i < columnWidths.length; i++) {
                if (columnWidths[i] != -1) {
                    TableColumn tc = table.getColumnModel().getColumn(i);
                    if (tc.getResizable()) {
                        tc.setPreferredWidth(columnWidths[i]);
                    }
                }
            }
        }
    }
}
