/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CardLayout2
extends CardLayout {
    private static Log log = LogFactory.getLog(CardLayout2.class);
    private static final long serialVersionUID = 1L;
    protected List<Serializable> contexts = new LinkedList<Serializable>();
    protected boolean useOnlyVisibleComponentDimension;

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        super.addLayoutComponent(comp, constraints);
        this.contexts.remove(constraints);
        this.contexts.add((Serializable)constraints);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " new constraints : " + constraints));
        }
    }

    public void removeLayoutComponent(Component comp, Serializable constraints) {
        this.removeLayoutComponent(comp);
        this.contexts.remove(constraints);
    }

    public boolean contains(Serializable constraints) {
        return this.contexts.contains(constraints);
    }

    public Component getVisibleComponent(Container container) {
        this.checkContainer(container);
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            return component;
        }
        return null;
    }

    public Component getComponent(Container container, String constraints) {
        this.checkContainer(container);
        this.checkConstraints(constraints);
        int index = this.contexts.indexOf(constraints);
        return container.getComponents()[index];
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component comp;
        Dimension dimension = null;
        if (this.useOnlyVisibleComponentDimension && (comp = this.getVisibleComponent(parent)) != null) {
            dimension = comp.getPreferredSize();
        }
        if (dimension == null) {
            dimension = super.preferredLayoutSize(parent);
        }
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Component comp;
        Dimension dimension = null;
        if (this.useOnlyVisibleComponentDimension && (comp = this.getVisibleComponent(parent)) != null) {
            dimension = comp.getMinimumSize();
        }
        if (dimension == null) {
            dimension = super.minimumLayoutSize(parent);
        }
        return dimension;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        Component comp;
        Dimension dimension = null;
        if (this.useOnlyVisibleComponentDimension && (comp = this.getVisibleComponent(target)) != null) {
            dimension = comp.getMaximumSize();
        }
        if (dimension == null) {
            dimension = super.maximumLayoutSize(target);
        }
        return dimension;
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.useOnlyVisibleComponentDimension) {
            Component comp = this.getVisibleComponent(parent);
            if (comp != null) {
                Insets insets = parent.getInsets();
                comp.setBounds(this.getHgap() + insets.left, this.getVgap() + insets.top, parent.getWidth() - (this.getHgap() * 2 + insets.left + insets.right), parent.getHeight() - (this.getVgap() * 2 + insets.top + insets.bottom));
            } else {
                super.layoutContainer(parent);
            }
        } else {
            super.layoutContainer(parent);
        }
    }

    public boolean isUseOnlyVisibleComponentDimension() {
        return this.useOnlyVisibleComponentDimension;
    }

    public void setUseOnlyVisibleComponentDimension(boolean useOnlyVisibleComponentDimension) {
        this.useOnlyVisibleComponentDimension = useOnlyVisibleComponentDimension;
    }

    public void reset(Container parent) {
        this.checkContainer(parent);
        for (Component component : parent.getComponents()) {
            this.removeLayoutComponent(component);
            parent.remove(component);
        }
        this.contexts.clear();
    }

    protected void checkContainer(Container container) {
        if (!this.equals(container.getLayout())) {
            throw new IllegalArgumentException("the container is not managed by the current layout");
        }
    }

    protected void checkConstraints(String constraints) {
        if (!this.contains((Serializable)((Object)constraints))) {
            throw new IllegalArgumentException("the constraints '" + constraints + "' is not supported by this layout : " + this.contexts);
        }
    }

    public Serializable[] getContexts() {
        return this.contexts.toArray(new Serializable[this.contexts.size()]);
    }
}

