/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavTreeTableBridge.java 2014 2010-06-30 17:24:16Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2/jaxx-runtime/src/main/java/jaxx/runtime/swing/nav/treetable/NavTreeTableBridge.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.nav.treetable;

import jaxx.runtime.swing.nav.NavBridge;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableNode;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

/**
 * Delegate model used to switch between tree model and tree table model api
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 2.1
 */
public class NavTreeTableBridge<N extends NavTreeTableNode<N>> implements NavBridge<NavTreeTableModel,  N> {

    /** Logger */
    static private final Log log = LogFactory.getLog(NavTreeTableBridge.class);

    /** bridge model */
    protected NavTreeTableModel model;

    /** bridge ui */
    protected JXTreeTable ui;

    public NavTreeTableBridge() {
        if (log.isDebugEnabled()) {
            log.debug("New " + this);
        }
    }

    //--------------------------------------------------------------------------
    //-- Model Queries
    //--------------------------------------------------------------------------

    @Override
    public NavTreeTableModel getModel() {
        return model;
    }

    @Override
    @SuppressWarnings({"unchecked"})
    public N getRoot() {
        return (N) model.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        return model.isLeaf(node);
    }

    @Override
    public int getChildCount(Object parent) {
        return model.getChildCount(parent);
    }

    @Override
    @SuppressWarnings({"unchecked"})
    public N getChild(Object parent, int index) {
        return (N) model.getChild(parent, index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return model.getIndexOfChild(parent, child);
    }

    @Override
    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return model.getPathToRoot((TreeTableNode) aNode);
    }

    //--------------------------------------------------------------------------
    //-- Model modification
    //--------------------------------------------------------------------------


    @Override
    public void setModel(NavTreeTableModel model) {
        this.model = model;
    }

    @Override
    public void setRoot(N node) {
        model.setRoot(node);
    }

    @Override
    public void insertNodeInto(N newChild, N parent, int index) {
        //FIXME c'est ca le code ? y'a rien d'ajoute au model c'est pas normal        
        model.nodeStructureChanged(parent);
    }

    @Override
    public void removeNodeFromParent(N node) {
        //FIXME c'est ca le code ? y'a rien de supprimer au model c'est pas normal
        model.nodeStructureChanged(node);
    }

    @Override
    public void reload(N node) {
        model.getModelSupport().fireTreeStructureChanged(new TreePath(getPathToRoot(node)));
    }

    //--------------------------------------------------------------------------
    //-- Listeners notifications
    //--------------------------------------------------------------------------

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        model.valueForPathChanged(path, newValue);
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        model.nodeStructureChanged((NavTreeTableNode<?>) node);
    }

    @Override
    public void nodeChanged(TreeNode node) {
        model.nodeChanged((NavTreeTableNode<?>) node);
    }

    @Override
    public void nodesChanged(TreeNode node, int[] childIndices) {
        //FIXME c'est plus fin que ça je pense, on indique juste que les fils ont
        // changé par le node en lui meme
        model.nodeChanged((NavTreeTableNode<?>) node);
    }

    @Override
    public void nodesWereInserted(N parent, int[] indices) {
        //FIXME, hum c'est louche (on ne veut pas recharger tout le noeud sinon
        // on peut perdre le positionnement de l'arbre
        nodeStructureChanged(parent);
    }

    @Override
    public void nodeWereInserted(N parentNode, int childIndice, N node) {
        //FIXME, hum c'est louche (on ne veut pas recharger tout le noeud sinon
        // on peut perdre le positionnement de l'arbre
        nodeStructureChanged(node);
    }

    @Override
    public void nodesWereRemoved(TreeNode node, int[] childIndices,
                                 Object[] removedChildren) {
        TreePath path = new TreePath(getPathToRoot(node));
        model.getModelSupport().fireChildrenRemoved(path,
                                                    childIndices,
                                                    removedChildren);
    }

    @Override
    @SuppressWarnings({"unchecked"})
    public void notifyChildNodesInserted(N node) {
        //FIXME quel raccourci :) pour moi ça va pas trop de faire ça c'est
        // trop violent, il faut affiner
        nodeStructureChanged(node);
    }

    @Override
    public void notifyNodeInserted(N node) {
        //FIXME quel raccourci :) pour moi ça va pas trop de faire ça c'est
        // trop violent, il faut affiner
        nodeStructureChanged(node);
    }

    //--------------------------------------------------------------------------
    //-- TreeModelListener provider
    //--------------------------------------------------------------------------


    @Override
    public void addTreeModelListener(TreeModelListener l) {
        model.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        model.removeTreeModelListener(l);
    }

    @Override
    public TreeModelListener[] getTreeModelListeners() {
        return model.getModelSupport().getTreeModelListeners();
    }

    @Override
    @SuppressWarnings({"unchecked"})
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        TreeModelListener[] treeModelListeners = getTreeModelListeners();
        List<TreeModelListener> result = new ArrayList<TreeModelListener>();
        for (TreeModelListener listener : treeModelListeners) {
            if (listener.getClass().isAssignableFrom(listenerType)) {
                result.add(listener);
            }
        }
        return (T[]) result.toArray();
    }

//    //--------------------------------------------------------------------------
//    //-- UI
//    //--------------------------------------------------------------------------
//
//    @Override
//    public JXTreeTable getUI() {
//        return ui;
//    }
//
//    @Override
//    public void setUI(JXTreeTable ui) {
//        this.ui = ui;
//    }
//
//    @Override
//    public void scrollPathToVisible(TreePath path) {
//        getUI().scrollPathToVisible(path);
//    }
//
//    @Override
//    public void setSelectionPath(TreePath path) {
//        getUI().getTreeSelectionModel().setSelectionPath(path);
//    }
//
//    @Override
//    public TreeSelectionModel getSelectionModel() {
//        return getUI().getTreeSelectionModel();
//    }
//
//    @Override
//    public boolean isExpanded(TreePath pathToExpand) {
//        return getUI().isExpanded(pathToExpand);
//    }
//
//    @Override
//    public void expandPath(TreePath pathToExpand) {
//        getUI().expandPath(pathToExpand);
//    }
//
//    @Override
//    public AbstractNavTreeCellRenderer<NavTreeTableModel, N> getTreeCellRenderer() {
//        //FIXME Implements it if possible
//        return null;
//    }
//
//    @SuppressWarnings({"unchecked"})
//    @Override
//    public N getSelectedNode() {
//        TreePath path = getSelectionModel().getSelectionPath();
//        N node = null;
//        if (path != null) {
//            node = (N) path.getLastPathComponent();
//        }
//        return node;
//    }

}