/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.nav;

import java.io.Serializable;
import java.util.List;
import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NavNodeChildLoador<T, O, M, B extends NavBridge<M, N>, N extends NavNode<M, N>>
implements Serializable {
    private static final Log log = LogFactory.getLog(NavNodeChildLoador.class);
    protected final Class<O> beanType;

    protected NavNodeChildLoador(Class<O> beanType) {
        this.beanType = beanType;
    }

    public abstract List<T> getData(Class<?> var1, String var2, NavDataProvider var3) throws Exception;

    public abstract N createNode(T var1, NavDataProvider var2);

    public Class<O> getBeanType() {
        return this.beanType;
    }

    public void loadChilds(B bridge, N parentNode, NavDataProvider dataProvider) throws Exception {
        List<T> datas;
        Object containerNode = parentNode.getContainerNode();
        if (containerNode == null) {
            datas = this.getData(null, null, dataProvider);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("search data for " + containerNode.getInternalClass() + " : " + containerNode.getId()));
            }
            datas = this.getData(containerNode.getInternalClass(), containerNode.getId(), dataProvider);
        }
        this.addChildNodes(parentNode, datas, dataProvider);
        bridge.notifyChildNodesInserted(parentNode);
    }

    protected void addChildNodes(N parentNode, List<T> datas, NavDataProvider dataProvider) {
        if (datas != null) {
            for (T o : datas) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("[" + parentNode + "] Will add child node for " + o));
                }
                N node = this.createNode(o, dataProvider);
                parentNode.add(node);
            }
        }
    }
}

