/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavigationNodeRenderer.java 1986 2010-06-23 08:58:14Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/navigation/NavigationNodeRenderer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.navigation;

import javax.swing.tree.TreeCellRenderer;
import java.io.Serializable;

/**
 * Text Renderer of a {@link NavigationNode}.
 * <p/>
 * This object will be placed as the {@link NavigationNode#getUserObject()} of
 * nodes.
 * <p/>
 * <p/>
 * In that way, we can use the {@link #toString()} value to render the node
 * without writing any {@link TreeCellRenderer}.
 * <p/>
 * To rebuild the renderer text of a node use the method {@link #reload(Object)}
 * with the {@code bean} provides by the model for the node.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.7.2, replace {@code NavigationUtil#NodeRenderer} which disappear
 *        soon...
 * @deprecated since 2.1, prefer use the simplify api {@code jaxx.runtime.swing.tree}.
 */
@Deprecated
public interface NavigationNodeRenderer extends Serializable {

    /** @return the render value of the node */
    @Override
    String toString();

    /**
     * Can override the node internal class for display purpose.
     *
     * @return the type of data to be displayed.
     */
    Class<?> getInternalClass();

    /**
     * Reload the render value from the {@code bean} of node.
     *
     * @param bean the bean associated to the node to render
     */
    void reload(Object bean);
}
