/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation.treetable;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.NavigationNodeRenderer;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class NavigationTreeTableNode
extends DefaultMutableTreeTableNode
implements NavigationNode<NavigationTreeTableNode> {
    private static final long serialVersionUID = -1L;
    private static final Log log = LogFactory.getLog(NavigationTreeTableNode.class);
    protected final String pathSeparator;
    protected String path;
    protected String fullPath;
    protected Class<? extends JAXXObject> uIClass;
    protected Class<? extends JAXXAction> uIHandlerClass;
    protected JAXXContextEntryDef<?> jaxxContextEntryDef;
    protected String jaxxContextEntryPath;
    protected transient Object bean;
    protected Class<?> internalClass;

    public NavigationTreeTableNode(String pathSeparator, String navigationPath, Object jaxxContextEntryDef) {
        this.pathSeparator = pathSeparator;
        this.path = navigationPath;
        if (jaxxContextEntryDef instanceof JAXXContextEntryDef) {
            this.jaxxContextEntryDef = (JAXXContextEntryDef)jaxxContextEntryDef;
        } else if (jaxxContextEntryDef instanceof String) {
            this.jaxxContextEntryPath = (String)jaxxContextEntryDef;
        } else if (jaxxContextEntryDef != null) {
            throw new IllegalArgumentException("to define a context link, must be a String (jxpath) or a " + JAXXContextEntryDef.class + ", but was " + jaxxContextEntryDef);
        }
    }

    public NavigationTreeTableNode(String pathSeparator, String navigationPath, JAXXContextEntryDef<?> jaxxContextEntryDef, String jaxxContextEntryPath) {
        this.pathSeparator = pathSeparator;
        this.path = navigationPath;
        this.jaxxContextEntryDef = jaxxContextEntryDef;
        this.jaxxContextEntryPath = jaxxContextEntryPath;
    }

    @Override
    public NavigationNodeRenderer getRenderer() {
        NavigationNodeRenderer render = null;
        Object o = this.getUserObject();
        if (o != null && o instanceof NavigationNodeRenderer) {
            render = (NavigationNodeRenderer)o;
        }
        return render;
    }

    @Override
    public void setRenderer(NavigationNodeRenderer renderer) {
        this.bean = null;
        this.setUserObject(renderer);
    }

    @Override
    public String getPathSeparator() {
        return this.pathSeparator;
    }

    @Override
    public String getNodePath() {
        return this.path;
    }

    @Override
    public void setNodePath(String navigationPath) {
        this.path = navigationPath;
    }

    @Override
    public Class<? extends JAXXObject> getUIClass() {
        return this.uIClass;
    }

    @Override
    public void setUIClass(Class<? extends JAXXObject> uIClass) {
        this.uIClass = uIClass;
    }

    @Override
    public void setInternalClass(Class<?> internalClass) {
        this.internalClass = internalClass;
    }

    @Override
    public Class<? extends JAXXAction> getUIHandlerClass() {
        return this.uIHandlerClass;
    }

    @Override
    public void setUIHandlerClass(Class<? extends JAXXAction> uIHandlerClass) {
        this.uIHandlerClass = uIHandlerClass;
    }

    @Override
    public JAXXContextEntryDef<?> getJaxxContextEntryDef() {
        return this.jaxxContextEntryDef;
    }

    @Override
    public void setJaxxContextEntryDef(JAXXContextEntryDef<?> jaxxContextEntryDef) {
        this.jaxxContextEntryDef = jaxxContextEntryDef;
    }

    @Override
    public String getJaxxContextEntryPath() {
        return this.jaxxContextEntryPath;
    }

    @Override
    public void setJaxxContextEntryPath(String jaxxContextEntryPath) {
        this.jaxxContextEntryPath = jaxxContextEntryPath;
    }

    @Override
    public Class<?> getInternalClass() {
        if (this.internalClass == null && this.getRenderer() != null) {
            return this.getRenderer().getInternalClass();
        }
        return this.internalClass;
    }

    @Override
    public String getFullPath() {
        if (this.fullPath == null) {
            StringBuilder sb = new StringBuilder();
            NavigationTreeTableNode[] arr$ = this.getPath();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                NavigationTreeTableNode treeNode;
                NavigationTreeTableNode myNode = treeNode = arr$[i$];
                sb.append(this.pathSeparator).append(myNode.getNodePath());
            }
            this.fullPath = sb.substring(1);
        }
        return this.fullPath;
    }

    protected NavigationTreeTableNode getFirstAncestorWithDef() {
        if (this.jaxxContextEntryDef != null) {
            return this;
        }
        NavigationTreeTableNode ancestor = this.getParent();
        return ancestor == null ? null : ancestor.getFirstAncestorWithDef();
    }

    protected String computeJXPath(String expr, NavigationTreeTableNode parentNode) {
        if (this.equals(parentNode)) {
            return expr;
        }
        int firstIndex = expr.indexOf("..");
        int lastIndex = expr.lastIndexOf("..");
        if (firstIndex == -1) {
            throw new IllegalArgumentException(expr + " should contains at least one \"..\"");
        }
        if (firstIndex != 0) {
            throw new IllegalArgumentException("\"..\" must be at the beginning but was : " + expr);
        }
        NavigationTreeTableNode ancestor = this.getParent();
        if (firstIndex == lastIndex) {
            String newExpr = expr.substring(2);
            if (this.getParent().equals(parentNode)) {
                return newExpr;
            }
            if (ancestor.jaxxContextEntryPath == null) {
                throw new IllegalArgumentException("with the expression " + expr + ", the ancestor node (" + ancestor + ") must have a jaxxContextEntryPath " + "definition, but was not ");
            }
            newExpr = ancestor.jaxxContextEntryPath + newExpr;
            return ancestor.computeJXPath(newExpr, parentNode);
        }
        if (ancestor.jaxxContextEntryPath != null) {
            throw new IllegalArgumentException("with the expression " + expr + ", the ancestor node can " + "not have a jaxxContextEntryPath definition");
        }
        String newExpr = expr.substring(0, lastIndex - 1) + expr.substring(lastIndex + (expr.charAt(lastIndex + 3) == '/' ? 3 : 2));
        return ancestor.computeJXPath(newExpr, parentNode);
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public void setBean(Object bean) {
        this.bean = bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(JAXXContext context) {
        this.bean = null;
        this.fullPath = null;
        NavigationNodeRenderer renderer = this.getRenderer();
        if (renderer == null) {
            throw new NullPointerException("could not find the renderer for node " + this);
        }
        String s = this.getFullPath();
        Object b = null;
        try {
            b = this.getBean(context);
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info((Object)("bean for path [" + s + "]  = " + this.bean));
            }
        }
        renderer.reload(b);
    }

    @Override
    public Object getBean(JAXXContext context) {
        if (this.bean != null) {
            return this.bean;
        }
        if (this.getJaxxContextEntryDef() != null && this.jaxxContextEntryPath == null) {
            Object result = this.getJaxxContextEntryDef().getContextValue(context);
            this.setBean(result);
            return result;
        }
        NavigationTreeTableNode parentNode = this.getFirstAncestorWithDef();
        if (parentNode == null) {
            log.warn((Object)("could not find a ancestor node with a definition of a context entry from node (" + this + ")"));
            return null;
        }
        Object parentBean = parentNode.getJaxxContextEntryDef().getContextValue(context);
        if (parentBean == null) {
            log.warn((Object)("could not find a bean attached in context from context entry definition " + parentNode.getJaxxContextEntryDef()));
            return null;
        }
        if (parentNode.jaxxContextEntryPath != null) {
            JXPathContext jxcontext = JXPathContext.newContext(parentBean);
            parentBean = jxcontext.getValue(parentNode.jaxxContextEntryPath);
        }
        parentNode.setBean(parentBean);
        if (parentNode.equals(this)) {
            return parentBean;
        }
        if (this.jaxxContextEntryPath == null) {
            log.warn((Object)("must find a jaxxContextEntryPath on node (" + this + ")"));
            return null;
        }
        String jxpathExpression = this.computeJXPath(this.jaxxContextEntryPath, parentNode);
        if (jxpathExpression == null) {
            log.warn((Object)("could not build jxpath from node " + parentNode + " to " + this));
            return null;
        }
        if (jxpathExpression.startsWith("[")) {
            jxpathExpression = '.' + jxpathExpression;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("jxpath : " + jxpathExpression));
        }
        JXPathContext jxcontext = JXPathContext.newContext(parentBean);
        Object result = jxcontext.getValue(jxpathExpression);
        this.setBean(result);
        return result;
    }

    @Override
    public NavigationTreeTableNode getChildAt(int index) {
        return (NavigationTreeTableNode)super.getChildAt(index);
    }

    @Override
    public NavigationTreeTableNode getParent() {
        return (NavigationTreeTableNode)super.getParent();
    }

    @Override
    public NavigationTreeTableNode getChild(String path) {
        Enumeration<? extends NavigationTreeTableNode> childs = this.children();
        while (childs.hasMoreElements()) {
            NavigationTreeTableNode son = childs.nextElement();
            if (!path.equals(son.getNodePath())) continue;
            return son;
        }
        return null;
    }

    @Override
    public Enumeration<? extends NavigationTreeTableNode> children() {
        return super.children();
    }

    @Override
    public void insert(NavigationTreeTableNode child, int index) {
        super.insert((MutableTreeTableNode)child, index);
    }

    @Override
    public void remove(NavigationTreeTableNode node) {
        super.remove((MutableTreeTableNode)node);
    }

    @Override
    public void setParent(NavigationTreeTableNode newParent) {
        super.setParent((MutableTreeTableNode)newParent);
    }

    @Override
    public int getIndex(NavigationTreeTableNode node) {
        return super.getIndex((TreeNode)((Object)node));
    }

    @Override
    public void add(NavigationTreeTableNode node) {
        super.add((MutableTreeTableNode)node);
    }

    public NavigationTreeTableNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public NavigationTreeTableNode[] getPathToRoot(NavigationTreeTableNode aNode, int depth) {
        NavigationTreeTableNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new NavigationTreeTableNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }
}

