/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.junit.Assert;
import org.junit.Test;

public class NavigationTreeModelTest {
    private static final String ROOT_CONTEXT = "$root";
    private static final String FAKE = "-fake";
    private static final String separator = "/";

    @Test
    public void testFindNode() throws Exception {
        NavigationTreeModelBuilder builder = new NavigationTreeModelBuilder(separator, (JAXXContext)new DefaultJAXXContext(), null, null);
        NavigationTreeNode rootNode = (NavigationTreeNode)builder.build(null, (String)null, (String)null, ROOT_CONTEXT, null, null);
        for (int i = 0; i < 4; ++i) {
            NavigationTreeNode sonNode = (NavigationTreeNode)builder.build((NavigationNode)rootNode, (String)null, (String)null, this.getNodeContext(i), null, null);
            for (int j = 0; j < 4; ++j) {
                NavigationTreeNode sonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonNode, (String)null, (String)null, this.getNodeContext(i, j), null, null);
                int k = 0;
                while (k < 4) {
                    builder.build((NavigationNode)sonSonNode, (String)null, (String)null, this.getNodeContext(i, j, k++), null, null);
                }
            }
        }
        NavigationTreeModel model = builder.getModel();
        String contextPath = ROOT_CONTEXT;
        NavigationTreeNode node = (NavigationTreeNode)model.findNode(contextPath);
        this.assertNodeEquals(contextPath, ROOT_CONTEXT, 0, node, true);
        node = (NavigationTreeNode)model.findNode("$root-fake");
        Assert.assertNull((Object)node);
        int i = 0;
        while (i < 4) {
            String currentNode = this.getNodeContext(i);
            contextPath = "$root/" + currentNode;
            node = (NavigationTreeNode)model.findNode(contextPath);
            this.assertNodeEquals(contextPath, currentNode, 1, node, false);
            int j = 0;
            while (j < 4) {
                currentNode = this.getNodeContext(i, j);
                contextPath = "$root/" + this.getNodeContext(i) + separator + currentNode;
                node = (NavigationTreeNode)model.findNode(contextPath);
                this.assertNodeEquals(contextPath, currentNode, 2, node, false);
                int k = 0;
                while (k < 4) {
                    currentNode = this.getNodeContext(i, j, k++);
                    contextPath = "$root/" + this.getNodeContext(i) + separator + this.getNodeContext(i, j) + separator + currentNode;
                    node = (NavigationTreeNode)model.findNode(contextPath);
                    this.assertNodeEquals(contextPath, currentNode, 3, node, false);
                }
                node = (NavigationTreeNode)model.findNode("$root/" + this.getNodeContext(i) + separator + this.getNodeContext(i, j++) + separator + currentNode + FAKE);
                Assert.assertNull((Object)node);
            }
            node = (NavigationTreeNode)model.findNode("$root/" + this.getNodeContext(i++) + separator + currentNode + FAKE);
            Assert.assertNull((Object)node);
        }
    }

    @Test
    public void testGetJAXXContextValue() throws Exception {
        DefaultJAXXContext context = new DefaultJAXXContext();
        context.setContextValue((Object)"the name", "name");
        context.setContextValue((Object)"the name2", "name2");
        context.setContextValue((Object)new Model("modelName", 10, Arrays.asList(new Model("one", 1, Collections.<Model>emptyList()), new Model("two", 2, Collections.<Model>emptyList()), new Model("three", 3, Collections.<Model>emptyList()))));
        NavigationTreeModelBuilder builder = new NavigationTreeModelBuilder(separator, (JAXXContext)context, null, null);
        NavigationTreeNode rootNode = (NavigationTreeNode)builder.build(null, (String)null, (String)null, ROOT_CONTEXT, null, null);
        builder.build((NavigationNode)rootNode, (String)null, JAXXUtil.newContextEntryDef((String)"name", String.class), "name", null, null);
        builder.build((NavigationNode)rootNode, (String)null, JAXXUtil.newContextEntryDef((String)"name2", String.class), "name2", null, null);
        NavigationTreeNode sonNode = (NavigationTreeNode)builder.build((NavigationNode)rootNode, (String)null, JAXXUtil.newContextEntryDef(Model.class), "model", null, null);
        builder.build((NavigationNode)sonNode, (String)null, "../name", "name", null, null);
        builder.build((NavigationNode)sonNode, (String)null, "../integerValue", "integerValue", null, null);
        NavigationTreeNode sonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonNode, (String)null, "../sons", "sons", null, null);
        NavigationTreeNode sonSonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonSonNode, (String)null, "..[1]", "0", null, null);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../name", "name", null, null);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../sons", "sons", null, null);
        sonSonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonSonNode, (String)null, "..[2]", "1", null, null);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../name", "name", null, null);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../sons", "sons", null, null);
        sonSonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonSonNode, (String)null, (String)null, "2", null, null);
        sonSonNode.insert(sonSonSonNode, 2);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../..[3]/name", "name", null, null);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../..[3]/integerValue", "integerValue", null, null);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../..[3]/sons", "sons", null, null);
        NavigationTreeModel model = builder.getModel();
        Assert.assertNull((Object)model.getBean("$root.name-fake"));
        this.testBinding((NavigationModel<?>)model, "$root/name", context.getContextValue(String.class, "name"));
        this.testBinding((NavigationModel<?>)model, "$root/name2", context.getContextValue(String.class, "name2"));
        Model bean = (Model)context.getContextValue(Model.class);
        this.testBinding((NavigationModel<?>)model, "$root/model", bean);
        this.testBinding((NavigationModel<?>)model, "$root/model/name", bean.getName());
        this.testBinding((NavigationModel<?>)model, "$root/model/integerValue", bean.getIntegerValue());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons", bean.getSons());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons/0/name", bean.getSons().get(0).getName());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons/0/integerValue", bean.getSons().get(0).getIntegerValue());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons/0/sons", bean.getSons().get(0).getSons());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons/1/name", bean.getSons().get(1).getName());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons/1/integerValue", bean.getSons().get(1).getIntegerValue());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons/1/sons", bean.getSons().get(1).getSons());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons/2/name", bean.getSons().get(2).getName());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons/2/integerValue", bean.getSons().get(2).getIntegerValue());
        this.testBinding((NavigationModel<?>)model, "$root/model/sons/2/sons", bean.getSons().get(2).getSons());
    }

    @Test
    public void testGetBeanFromList() throws Exception {
        List<Model> list = Arrays.asList(new Model("entryOne", 10, Arrays.asList(new Model("one", 1, Collections.<Model>emptyList()), new Model("two", 2, Collections.<Model>emptyList()), new Model("three", 3, Collections.<Model>emptyList()))), new Model("entryTwo", 20, Arrays.asList(new Model("2one", 1, Collections.<Model>emptyList()), new Model("2two", 2, Collections.<Model>emptyList()), new Model("2three", 3, Collections.<Model>emptyList()))), new Model("entryThree", 30, Arrays.asList(new Model("3one", 1, Collections.<Model>emptyList()), new Model("3two", 2, Collections.<Model>emptyList()), new Model("3three", 3, Collections.<Model>emptyList()))));
        DefaultJAXXContext context = new DefaultJAXXContext();
        context.setContextValue(list, "models");
        NavigationTreeModelBuilder builder = new NavigationTreeModelBuilder(separator, (JAXXContext)context, null, null);
        NavigationTreeNode rootNode = (NavigationTreeNode)builder.build(null, (String)null, (String)null, ROOT_CONTEXT, null, null);
        NavigationTreeNode sonNode = (NavigationTreeNode)builder.build((NavigationNode)rootNode, (String)null, JAXXUtil.newListContextEntryDef((String)"models"), "models", null, null);
        NavigationTreeNode sonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonNode, (String)null, "..[1]", "0", null, null);
        builder.build((NavigationNode)sonSonNode, (String)null, "../name", "name", null, null);
        builder.build((NavigationNode)sonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        sonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonSonNode, (String)null, "../sons", "sons", null, null);
        NavigationTreeNode sonSonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonSonNode, (String)null, "..[1]", "0", null, null);
        builder.build((NavigationNode)sonSonSonNode, (String)null, "../name", "name", null, null);
        sonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonNode, (String)null, "..[2]", "1", null, null);
        builder.build((NavigationNode)sonSonNode, (String)null, "../name", "name", null, null);
        builder.build((NavigationNode)sonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        builder.build((NavigationNode)sonSonNode, (String)null, "../sons", "sons", null, null);
        sonSonNode = (NavigationTreeNode)builder.build((NavigationNode)sonNode, (String)null, "..[3]", "2", null, null);
        builder.build((NavigationNode)sonSonNode, (String)null, "../name", "name", null, null);
        builder.build((NavigationNode)sonSonNode, (String)null, "../integerValue", "integerValue", null, null);
        builder.build((NavigationNode)sonSonNode, (String)null, "../sons", "sons", null, null);
        NavigationTreeModel model = builder.getModel();
        this.testBinding((NavigationModel<?>)model, "$root/models", list);
        Model bean = list.get(0);
        this.testBinding((NavigationModel<?>)model, "$root/models/0", bean);
        this.testBinding((NavigationModel<?>)model, "$root/models/0/name", bean.getName());
        this.testBinding((NavigationModel<?>)model, "$root/models/0/integerValue", bean.getIntegerValue());
        this.testBinding((NavigationModel<?>)model, "$root/models/0/sons", bean.getSons());
        this.testBinding((NavigationModel<?>)model, "$root/models/0/sons/0", bean.getSons().get(0));
        this.testBinding((NavigationModel<?>)model, "$root/models/0/sons/0/name", bean.getSons().get(0).getName());
        bean = list.get(1);
        this.testBinding((NavigationModel<?>)model, "$root/models/1", bean);
        this.testBinding((NavigationModel<?>)model, "$root/models/1/name", bean.getName());
        this.testBinding((NavigationModel<?>)model, "$root/models/1/integerValue", bean.getIntegerValue());
        this.testBinding((NavigationModel<?>)model, "$root/models/1/sons", bean.getSons());
        bean = list.get(2);
        this.testBinding((NavigationModel<?>)model, "$root/models/2", bean);
        this.testBinding((NavigationModel<?>)model, "$root/models/2/name", bean.getName());
        this.testBinding((NavigationModel<?>)model, "$root/models/2/integerValue", bean.getIntegerValue());
        this.testBinding((NavigationModel<?>)model, "$root/models/2/sons", bean.getSons());
    }

    protected void testBinding(NavigationModel<?> model, String contextPath, Object expected) throws Exception {
        Object value = model.getBean(contextPath);
        Assert.assertNotNull((String)("could not find bean for path : " + contextPath), (Object)value);
        Assert.assertEquals((Object)expected, (Object)value);
    }

    protected String getNodeContext(int ... context) {
        String result = "";
        for (int i : context) {
            result = result + i;
        }
        return result;
    }

    protected void assertNodeEquals(String contextPath, String nodeContext, int level, NavigationTreeNode node, boolean root) {
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)root, (Object)node.isRoot());
        Assert.assertEquals((long)level, (long)node.getLevel());
        Assert.assertEquals((Object)nodeContext, (Object)node.getNodePath());
        Assert.assertEquals((Object)contextPath, (Object)node.getFullPath());
    }

    public static class Model {
        protected String name;
        protected int integerValue;
        protected List<Model> sons;

        public Model(String name, int integerValue, List<Model> sons) {
            this.name = name;
            this.integerValue = integerValue;
            this.sons = sons;
        }

        public String getName() {
            return this.name;
        }

        public int getIntegerValue() {
            return this.integerValue;
        }

        public List<Model> getSons() {
            return this.sons;
        }

        public String toString() {
            return super.toString() + "<name:" + this.name + ",integerValue:" + this.integerValue + ",sons: " + this.sons + ">";
        }
    }
}

