package jaxx.runtime.swing.renderer;

import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;

import javax.swing.*;
import java.awt.*;

/**
 * A {@link ListCellRenderer} which use decorators from the {@link #provider} to obtain the text to display.
 *
 * The interest of this renderer is to define a unique renderer for your application (put it in JAXXContext)
 * and then use it simply :)
 * 
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 03:00:53
 * @since 2.0.0
 * @see DecoratorProvider
 */
public class DecoratorProviderListCellRenderer implements ListCellRenderer {

    /**
     * Delegate cell renderer
     */
    protected ListCellRenderer delegate;

    /**
     * provider of decorators
     */
    protected DecoratorProvider provider;

    public DecoratorProviderListCellRenderer(DecoratorProvider provider) {
        this(new DefaultListCellRenderer(), provider);
    }

    public DecoratorProviderListCellRenderer(ListCellRenderer delegate, DecoratorProvider provider) {
        this.delegate = delegate;
        this.provider = provider;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            Decorator<?> decorator = provider.getDecorator(value);

            if (decorator != null) {
                value = decorator.toString(value);
            }
        } else {
            value = " ";
        }
        return delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
    }
}
