package jaxx.runtime.swing.navigation.treetable;

import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.AbstractNavigationModelBuilder;

import java.util.List;

public class NavigationTreeTableModelBuilder extends AbstractNavigationModelBuilder<NavigationTreeTableNode> {

    public NavigationTreeTableModelBuilder(
            String pathSeparator,
            JAXXContext context,
            Class<? extends JAXXObject> defaultUIClass,
            Class<? extends JAXXAction> defaultUIHandlerClass,
            List<String> columnsName) {
        this(defaultUIClass,
             defaultUIHandlerClass,
             new NavigationTreeTableModel(pathSeparator, context, columnsName)
        );
    }

    public NavigationTreeTableModelBuilder(
            Class<? extends JAXXObject> defaultUIClass,
            Class<? extends JAXXAction> defaultUIHandlerClass,
            NavigationTreeTableModel model) {
        super(defaultUIClass, defaultUIHandlerClass, model);
    }

    @Override
    public NavigationTreeTableNode createNavigationNode(
            String pathSeparator,
            String contextName,
            JAXXContextEntryDef<?> jaxxContextEntryDef,
            String jaxxContextEntryPath) {
        return new NavigationTreeTableNode(
                pathSeparator,
                contextName,
                jaxxContextEntryDef,
                jaxxContextEntryPath
        );
    }

    @Override
    public NavigationTreeTableModel getModel() {
        return (NavigationTreeTableModel) super.getModel();
    }
}
