/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.swing.navigation;

import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/** A {@link javax.swing.event.TreeSelectionListener}  implementation@@author letellier */
public abstract class ItemTreeNavigationAdapter  implements TreeSelectionListener {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private final Log log = LogFactory.getLog(ItemTreeNavigationAdapter.class);

    /** l'ui contenant l'arbre de navigation */
    protected JAXXObject context;

    protected JAXXTree tree;
    protected ItemNavigationCardPanel cardPanel;

    public ItemTreeNavigationAdapter(JAXXObject context, JAXXTree tree, ItemNavigationCardPanel cardPanel) {
        super();
        this.context = context;
        this.tree = tree;
        this.cardPanel = cardPanel;

        // Attache ce listener a l'arbre de navigation
        tree.addTreeSelectionListener(this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        log.debug("Selection in JAXXTree changed" + e.getPath());

        // Recuperation du path selectionne
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null){
            path = e.getOldLeadSelectionPath();
        }
        TreeModel model = tree.getModel();

        if (!(model instanceof JAXXTreeModel)){
            log.error("Its not an JAXXTreeModel");
            return;
        }
        
        // Find item coresponding
        Object lastPathComponent = path.getLastPathComponent();
        Item itemSelected = ((JAXXTreeModel) model).findItem(lastPathComponent);

        // Show corresponding panel
        cardPanel.showItem(itemSelected);

        // Notifie change
        valueChanged(itemSelected.getValue());
    }

    /**
     * Method abstraite pour pouvoir propager la donnee selectionner
     *
     * @param data value of the node selected
     */
    protected abstract void valueChanged(Object data);
}
