/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.decorator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jaxx.runtime.decorator.Data;
import jaxx.runtime.decorator.DecoratorUtils;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.decorator.MultiJXPathDecorator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MultiJXPathDecoratorTest {
    protected MultiJXPathDecorator<?> decorator;
    protected String expected;
    protected String result;

    @After
    public void after() {
        this.decorator = null;
    }

    @Test(expected=NullPointerException.class)
    public void testNullInternalClass() throws Exception {
        this.decorator = DecoratorUtils.newMultiJXPathDecorator(null, (String)"hello", (String)"#");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingRightBrace() throws Exception {
        this.decorator = DecoratorUtils.newMultiJXPathDecorator(Object.class, (String)"${haha", (String)"#");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingRightBrace2() throws Exception {
        this.decorator = DecoratorUtils.newMultiJXPathDecorator(Object.class, (String)"${haha${hum}", (String)"#");
    }

    @Test
    public void testNullBean() throws Exception {
        this.decorator = DecoratorUtils.newMultiJXPathDecorator(Object.class, (String)"hello", (String)"");
        this.expected = "hello";
        Assert.assertEquals((Object)this.expected, (Object)this.decorator.getExpression());
        Assert.assertEquals((long)0L, (long)this.decorator.nbToken);
        Assert.assertEquals((long)0L, (long)this.decorator.getTokens().length);
        this.result = this.decorator.toString(null);
        Assert.assertEquals(null, (Object)this.result);
    }

    @Test
    public void testMultiDecorator() throws Exception {
        this.decorator = DecoratorUtils.newMultiJXPathDecorator(JXPathDecorator.class, (String)"${expression}$s#${nbToken}$d", (String)"#", (String)" - ");
        Assert.assertEquals((Object)"%1$s - %2$d", (Object)this.decorator.getExpression());
        this.assertDecoratorInternal(new String[0]);
        Assert.assertEquals((long)2L, (long)this.decorator.contexts.length);
        this.decorator.setContextIndex(1);
        Assert.assertEquals((Object)"%1$d - %2$s", (Object)this.decorator.getExpression());
        this.assertTokens("nbToken", "expression");
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getNbToken(), this.decorator.getExpression());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
        this.decorator = DecoratorUtils.newMultiJXPathDecorator(JXPathDecorator.class, (String)"${expression}$s ## ${nbToken}$d", (String)" ## ", (String)" - ");
        Assert.assertEquals((Object)"%1$s - %2$d", (Object)this.decorator.getExpression());
        this.assertDecoratorInternal(new String[0]);
        Assert.assertEquals((long)2L, (long)this.decorator.contexts.length);
        this.decorator.setContextIndex(1);
        Assert.assertEquals((Object)"%1$d - %2$s", (Object)this.decorator.getExpression());
        this.assertTokens("nbToken", "expression");
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getNbToken(), this.decorator.getExpression());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
    }

    @Test
    public void testMultiDecorator2() throws Exception {
        this.decorator = DecoratorUtils.newMultiJXPathDecorator(JXPathDecorator.class, (String)"${expression}$s#${nbToken}$d#${separator}$s", (String)"#", (String)" - ");
        Assert.assertEquals((Object)"%1$s - %2$d - %3$s", (Object)this.decorator.getExpression());
        this.assertTokens("expression", "nbToken", "separator");
        Assert.assertEquals((long)3L, (long)this.decorator.contexts.length);
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getExpression(), this.decorator.getNbToken(), this.decorator.getSeparator());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
        this.decorator.setContextIndex(1);
        Assert.assertEquals((Object)"%1$d - %2$s - %3$s", (Object)this.decorator.getExpression());
        this.assertTokens("nbToken", "separator", "expression");
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getNbToken(), this.decorator.getSeparator(), this.decorator.getExpression());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
        this.decorator.setContextIndex(2);
        Assert.assertEquals((Object)"%1$s - %2$s - %3$d", (Object)this.decorator.getExpression());
        this.assertTokens("separator", "expression", "nbToken");
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getSeparator(), this.decorator.getExpression(), this.decorator.getNbToken());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
    }

    @Test
    public void testMultiDecoratorWithMultiRef() throws Exception {
        this.decorator = DecoratorUtils.newMultiJXPathDecorator(JXPathDecorator.class, (String)"${expression}$s#${nbToken}$d#${separator}$s %3$s", (String)"#", (String)" - ");
        Assert.assertEquals((Object)"%1$s - %2$d - %3$s %3$s", (Object)this.decorator.getExpression());
        this.assertTokens("expression", "nbToken", "separator");
        Assert.assertEquals((long)3L, (long)this.decorator.contexts.length);
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getExpression(), this.decorator.getNbToken(), this.decorator.getSeparator());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
        this.decorator.setContextIndex(1);
        Assert.assertEquals((Object)"%1$d - %2$s %3$s - %3$s", (Object)this.decorator.getExpression());
        this.assertTokens("nbToken", "separator", "expression");
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getNbToken(), this.decorator.getSeparator(), this.decorator.getExpression());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
        this.decorator.setContextIndex(2);
        Assert.assertEquals((Object)"%1$s %3$s - %2$s - %3$d", (Object)this.decorator.getExpression());
        this.assertTokens("separator", "expression", "nbToken");
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getSeparator(), this.decorator.getExpression(), this.decorator.getNbToken());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
    }

    @Test
    public void testSort() throws Exception {
        Data sData;
        Data data;
        int i;
        List<Data> datas = Data.generate(10);
        MultiJXPathDecorator d = DecoratorUtils.newMultiJXPathDecorator(Data.class, (String)"${pos}$d-${name}$s", (String)"-");
        ArrayList<Data> sortData = new ArrayList<Data>(datas);
        DecoratorUtils.sort((JXPathDecorator)d, sortData, (int)0);
        for (i = 0; i < datas.size(); ++i) {
            data = datas.get(i);
            sData = (Data)sortData.get(i);
            Assert.assertEquals((Object)data, (Object)sData);
        }
        Collections.sort(datas, new Comparator<Data>(){

            @Override
            public int compare(Data o1, Data o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        d.setContextIndex(1);
        DecoratorUtils.sort((JXPathDecorator)d, sortData, (int)1);
        for (i = 0; i < datas.size(); ++i) {
            data = datas.get(i);
            sData = (Data)sortData.get(i);
            Assert.assertEquals((Object)data, (Object)sData);
        }
    }

    public void assertDecoratorInternal(String ... tokens) {
        this.assertTokens(tokens);
        this.expected = String.format(this.decorator.getExpression(), this.decorator.getExpression(), this.decorator.getNbToken());
        this.result = this.decorator.toString(this.decorator);
        Assert.assertEquals((Object)this.expected, (Object)this.result);
    }

    private void assertTokens(String ... tokens) {
        if (tokens.length == 0) {
            tokens = new String[]{"expression", "nbToken"};
        }
        Assert.assertEquals((long)tokens.length, (long)this.decorator.nbToken);
        Assert.assertEquals((long)tokens.length, (long)this.decorator.getTokens().length);
        for (int i = 0; i < tokens.length; ++i) {
            Assert.assertEquals((Object)tokens[i], (Object)this.decorator.getTokens()[i]);
        }
    }
}

