package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n.t;

public class JProgressBarDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BLUE = "blue";
    public static final String PROPERTY_GREEN = "green";
    public static final String PROPERTY_RED = "red";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLUE_PROGRESS_BAR_FOREGROUND = "blueProgressBar.foreground";
    public static final String BINDING_BLUE_PROGRESS_BAR_VALUE = "blueProgressBar.value";
    public static final String BINDING_GREEN_PROGRESS_BAR_FOREGROUND = "greenProgressBar.foreground";
    public static final String BINDING_GREEN_PROGRESS_BAR_VALUE = "greenProgressBar.value";
    public static final String BINDING_RED_PROGRESS_BAR_FOREGROUND = "redProgressBar.foreground";
    public static final String BINDING_RED_PROGRESS_BAR_VALUE = "redProgressBar.value";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_FOREGROUND = "$JLabel0.foreground";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS08TURS+LX3Q8rQmxo0JkQo+cAoxLgyIPBoiTRUEFsRuuO1c2iHTueO9d2DYsHDhzj/gwq0bw38grkzcuOU/mPATPPfOwLRNZ6xtFzPteXzn+8695/T7H5TkDM1RVtcsxxDU0o6w62rMsYTRJFppdX9/q3pEaqJIeI0ZtqAMeZ9YHMUraES/sXOBtEoZkAoeUkEiFXykwjpt2tQiVgvQYhlluTg1CW8QIgR6GJpc47ywexO56NoO82t1Zd2t1q9PC5cxUvwSR8i1gX4OZD/5D4BAdaKM4oYuUK58hI9xwcRWHcgxw6qDoDFpWzcx529xk3xAZyhdRikbMwAT6Glf7VFwCsq1BRrJF0mTbmOLmPMCPe+UoINTq12jafwEeGmlbUbrjHC+hpnMtm2FlxJoiBGQckuy1qQSbdMSpE5YEJGERGLJH+OBMVE1HdJhS3KbEL3DOAr4RYPBBTJoJ8i4Qg7zjskSYc5hgN2DvjGfu+sLVbYgLKsqKKO03As8GYnezZHO7+GqSaC102G3wy8lw2RSJmCVL5VxVZ1LrpWVZ5VB9wPxoKDlVAS625bR4mrPm1SSOtyP22MmpLjokEy+tOYIkAZcb7dV9swh0QvSsOA7GZoJaxEMrBYMbDA7sQpKMgfM0N7wXSHHfQeivEGfDh90WUYFfjw/Y99Ori6vp3sCyE39K6tlkcGo2YzacJ8MyW3CG21HGGbhDbYXKyjDiQk3UW252Wjmu34ksAcW3mhJJO015g1AS6YvL37cOfg9hOIbKGtSrG9gGb+JMqIBJ9agpu7ar1YUudGTYXhOSpoCpUx8SuEc0PiSjgWeqhqWDme27EKXZqO7dEPqfOvq59fPDy6uOxUDjvleMoNuJd+jlGGZhkXUJvSXXNfNN2Jz4ug02GDddlpMvrO2P4Mv1PNlN/2JQ2oJ6V1xHflaVfzlt3WFMdMDRvaQMlJn1LH0AZESgrhwFrklrxdTWMCfQNURZLlfTGkuR7B61AOrdBO7RtNpyoCd/mGSx9jf8H1z+ZeauZ4QKhFCekM4GJhDlAptYBW9IUSp6A3hXQSH+YERngHCXxavxBtOCgAA";
    private static final Log log = LogFactory.getLog(JProgressBarDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Integer blue;
    protected Integer blueDirection;
    protected JProgressBar blueProgressBar;
    protected Timer blueTimer;
    protected Integer green;
    protected Integer greenDirection;
    protected JProgressBar greenProgressBar;
    protected Timer greenTimer;
    protected Integer red;
    protected Integer redDirection;
    protected JProgressBar redProgressBar;
    protected Timer redTimer;
    protected Integer speed;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JProgressBarDemo $DemoPanel0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JLabel $JLabel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void startTimers() {
        redTimer.start();
        greenTimer.start();
        blueTimer.start();
    }
    
    void stopTimers() {
        redTimer.stop();
        greenTimer.stop();
        blueTimer.stop();
    }
    
    void $afterCompleteSetup() {
        startTimers();
    }
    
    protected void changeRedValue() {
        setRed(Math.max(0, Math.min(255, red + speed * redDirection)));
        if (red == 0 || red == 255) {
            redDirection = -redDirection;
        }
    }
    protected void changeGreenValue() {
        setGreen(Math.max(0, Math.min(255, green + speed * greenDirection)));
        if (green == 0 || green == 255) {
            greenDirection = -greenDirection;
        }
    }
    protected void changeBlueValue() {
        setBlue(Math.max(0, Math.min(255, blue + speed * blueDirection)));
        if (blue == 0 || blue == 255) {
            blueDirection = -blueDirection;
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JProgressBarDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JProgressBarDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JProgressBarDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JProgressBarDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JProgressBarDemo() {
        $initialize();
    }

    public JProgressBarDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JProgressBarDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JProgressBarDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        startTimers();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        stopTimers();
    }

    public void doActionPerformed__on__blueTimer(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        changeBlueValue();
    }

    public void doActionPerformed__on__greenTimer(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        changeGreenValue();
    }

    public void doActionPerformed__on__redTimer(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        changeRedValue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Integer getBlue() {
        return blue;
    }

    public Integer getBlueDirection() {
        return blueDirection;
    }

    public JProgressBar getBlueProgressBar() {
        return blueProgressBar;
    }

    public Timer getBlueTimer() {
        return blueTimer;
    }

    public Integer getGreen() {
        return green;
    }

    public Integer getGreenDirection() {
        return greenDirection;
    }

    public JProgressBar getGreenProgressBar() {
        return greenProgressBar;
    }

    public Timer getGreenTimer() {
        return greenTimer;
    }

    public Integer getRed() {
        return red;
    }

    public Integer getRedDirection() {
        return redDirection;
    }

    public JProgressBar getRedProgressBar() {
        return redProgressBar;
    }

    public Timer getRedTimer() {
        return redTimer;
    }

    public Integer getSpeed() {
        return speed;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBlue(Integer blue) {
        Integer oldValue = this.blue;
        this.blue = blue;
        firePropertyChange(PROPERTY_BLUE, oldValue, blue);
    }

    public void setGreen(Integer green) {
        Integer oldValue = this.green;
        this.green = green;
        firePropertyChange(PROPERTY_GREEN, oldValue, green);
    }

    public void setRed(Integer red) {
        Integer oldValue = this.red;
        this.red = red;
        firePropertyChange(PROPERTY_RED, oldValue, red);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBlue() {
        $objectMap.put("blue", blue = 0);
    }

    protected void createBlueDirection() {
        $objectMap.put("blueDirection", blueDirection = 1);
    }

    protected void createBlueProgressBar() {
        $objectMap.put("blueProgressBar", blueProgressBar = new JProgressBar());
        
        blueProgressBar.setName("blueProgressBar");
        blueProgressBar.setMaximum(255);
    }

    protected void createBlueTimer() {
        $objectMap.put("blueTimer", blueTimer = new Timer(500, null));
        
        blueTimer.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__blueTimer"));
    }

    protected void createGreen() {
        $objectMap.put("green", green = 0);
    }

    protected void createGreenDirection() {
        $objectMap.put("greenDirection", greenDirection = 1);
    }

    protected void createGreenProgressBar() {
        $objectMap.put("greenProgressBar", greenProgressBar = new JProgressBar());
        
        greenProgressBar.setName("greenProgressBar");
        greenProgressBar.setMaximum(255);
    }

    protected void createGreenTimer() {
        $objectMap.put("greenTimer", greenTimer = new Timer(50, null));
        
        greenTimer.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__greenTimer"));
    }

    protected void createRed() {
        $objectMap.put("red", red = 0);
    }

    protected void createRedDirection() {
        $objectMap.put("redDirection", redDirection = 1);
    }

    protected void createRedProgressBar() {
        $objectMap.put("redProgressBar", redProgressBar = new JProgressBar());
        
        redProgressBar.setName("redProgressBar");
        redProgressBar.setMaximum(255);
    }

    protected void createRedTimer() {
        $objectMap.put("redTimer", redTimer = new Timer(5, null));
        
        redTimer.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__redTimer"));
    }

    protected void createSpeed() {
        $objectMap.put("speed", speed = 2);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createRed();
        createGreen();
        createBlue();
        createSpeed();
        createRedDirection();
        createGreenDirection();
        createBlueDirection();
        createRedTimer();
        createGreenTimer();
        createBlueTimer();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Welcome to the JAXX framework!"));
        createRedProgressBar();
        createGreenProgressBar();
        createBlueProgressBar();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("Start"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("Stop"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_FOREGROUND, true ,"red" ,"green" ,"blue") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setForeground(new Color(getRed(), getGreen(), getBlue()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RED_PROGRESS_BAR_FOREGROUND, true ,"red") {
        
            @Override
            public void processDataBinding() {
                redProgressBar.setForeground(new Color(getRed(), 0, 0));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RED_PROGRESS_BAR_VALUE, true ,"red") {
        
            @Override
            public void processDataBinding() {
                redProgressBar.setValue(getRed());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GREEN_PROGRESS_BAR_FOREGROUND, true ,"green") {
        
            @Override
            public void processDataBinding() {
                greenProgressBar.setForeground(new Color(0, getGreen(), 0));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GREEN_PROGRESS_BAR_VALUE, true ,"green") {
        
            @Override
            public void processDataBinding() {
                greenProgressBar.setValue(getGreen());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BLUE_PROGRESS_BAR_FOREGROUND, true ,"blue") {
        
            @Override
            public void processDataBinding() {
                blueProgressBar.setForeground(new Color(0, 0, getBlue()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BLUE_PROGRESS_BAR_VALUE, true ,"blue") {
        
            @Override
            public void processDataBinding() {
                blueProgressBar.setValue(getBlue());
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add(redProgressBar, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add(greenProgressBar, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add(blueProgressBar, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 6, 6, 6), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 2 property setters
        $JLabel0.setFont(UIManager.getFont("Label.font").deriveFont(18f));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}