/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.types;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.nuiton.jaxx.compiler.types.TypeConverter;

public class TypeManager {
    private static Map<Class<?>, TypeConverter> converters;

    public static Map<Class<?>, TypeConverter> getConverters() {
        if (converters == null) {
            converters = new HashMap();
            ServiceLoader<TypeConverter> loader = ServiceLoader.load(TypeConverter.class);
            for (TypeConverter c : loader) {
                for (Class<?> type : c.getSupportedTypes()) {
                    converters.put(type, c);
                }
            }
        }
        return converters;
    }

    private TypeManager() {
    }

    public static TypeConverter getTypeConverter(Class<?> type) {
        return TypeManager.getConverters().get(type);
    }

    public static String getJavaCode(Object object) {
        if (object == null) {
            return "null";
        }
        TypeConverter converter = TypeManager.getTypeConverter(object.getClass());
        if (converter == null) {
            throw new IllegalArgumentException("unsupported type: " + object.getClass());
        }
        return converter.getJavaCode(object);
    }

    public static Object convertFromString(String string, Class<?> type) {
        TypeConverter converter = TypeManager.getTypeConverter(type);
        if (converter == null) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        return converter.convertFromString(string, type);
    }

    public static String convertVariableNameToConstantName(String variableName) {
        StringBuilder buffer = new StringBuilder();
        boolean lastCarIsUp = false;
        char lastChar = '$';
        int j = variableName.length();
        for (int i = 0; i < j; ++i) {
            boolean carIsUp;
            char c = variableName.charAt(i);
            if (c == '!') {
                buffer.append("NOT_");
                lastChar = '_';
                lastCarIsUp = true;
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                carIsUp = Character.isUpperCase(c);
            } else {
                carIsUp = false;
                if (c != '$') {
                    if (lastChar == '_' && c != '_') continue;
                    c = '_';
                }
            }
            if (i > 0 && !lastCarIsUp && carIsUp) {
                buffer.append('_');
            }
            if (carIsUp) {
                buffer.append(c);
            } else {
                buffer.append(Character.toUpperCase(c));
            }
            lastCarIsUp = carIsUp || c == '$' || c == '_';
            lastChar = c;
        }
        return buffer.toString();
    }
}

