/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.binding;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.compiler.java.parser.SimpleNode;

public class JavaParserUtil {
    private static final Log log = LogFactory.getLog(JavaParserUtil.class);
    private static final Comparator<String> STRING_LENGTH_COMPARATOR = Comparator.comparingInt(String::length);

    public static void getExpressions(SimpleNode node, Map<SimpleNode, List<SimpleNode>> store, List<SimpleNode> literals, Map<SimpleNode, List<SimpleNode>> casts) {
        if (node.getId() == 22 || node.getId() == 17) {
            return;
        }
        if (node.getId() == 62) {
            JavaParserUtil.scanForExpressions(node, null, store, literals, casts);
            return;
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            JavaParserUtil.getExpressions(node.getChild(i), store, literals, casts);
        }
    }

    public static void removeLiteralExpressions(Map<SimpleNode, List<SimpleNode>> store, List<SimpleNode> literalExpressions) {
        for (SimpleNode n : literalExpressions) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reject literal expression " + n.getText()));
            }
            for (List<SimpleNode> dependencies : store.values()) {
                dependencies.remove(n);
            }
            store.remove(n);
        }
    }

    public static void removeNoneStandaloneExpressions(Map<SimpleNode, List<SimpleNode>> store, Map<SimpleNode, List<SimpleNode>> castsExpressions) {
        ArrayList<SimpleNode> rejectedExpressions = new ArrayList<SimpleNode>();
        for (Map.Entry<SimpleNode, List<SimpleNode>> e : store.entrySet()) {
            List<SimpleNode> dependencies = e.getValue();
            SimpleNode node = e.getKey();
            if (castsExpressions.containsKey(node) || dependencies.isEmpty()) continue;
            rejectedExpressions.add(node);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Reject expression " + node.getText() + " with " + dependencies.size() + " dependencies"));
            for (SimpleNode n : dependencies) {
                log.debug((Object)("  " + n.getText()));
            }
        }
        for (SimpleNode node : rejectedExpressions) {
            store.remove(node);
        }
        rejectedExpressions.clear();
    }

    public static Set<String> getRequired(Set<SimpleNode> store, Map<SimpleNode, List<SimpleNode>> casts) {
        if (store.isEmpty()) {
            return null;
        }
        LinkedHashSet<SimpleNode> castCodes = new LinkedHashSet<SimpleNode>();
        for (List<SimpleNode> list : casts.values()) {
            for (SimpleNode node : list) {
                castCodes.add(node);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("cast = " + node.getText().trim()));
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (SimpleNode node : store) {
            String expression = node.getText().trim();
            if (result.contains(expression)) continue;
            for (SimpleNode castCode : castCodes) {
                String str = castCode.getText().trim();
                int index = expression.indexOf(str);
                if (index <= -1) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("got a cast in expresion " + expression + " = " + castCode));
                }
                String tmp = "";
                if (index > 1) {
                    tmp = expression.substring(0, index - 1);
                }
                tmp = tmp + ((SimpleNode)castCode.jjtGetChild(1)).getText().trim() + expression.substring(index + str.length() + 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("REMOVED CAST : " + tmp));
                }
                expression = tmp;
            }
            if (!expression.contains(".")) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Reject simple expression " + expression));
                continue;
            }
            if (!expression.contains("(")) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Reject constant or static expression " + expression));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keep expression " + expression));
            }
            result.add(expression);
        }
        if (result.isEmpty()) {
            return null;
        }
        result.sort(STRING_LENGTH_COMPARATOR);
        if (log.isDebugEnabled()) {
            log.debug((Object)("======= start with values : " + result));
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String expression : result) {
            String s;
            String args;
            String args2;
            LinkedHashSet<String> tmp = new LinkedHashSet<String>();
            Object[] paths = expression.split("\\s*\\.\\s*");
            if (paths.length < 2) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expression to treate : " + expression + " :: " + Arrays.toString(paths)));
            }
            StringBuilder buffer = new StringBuilder();
            String last = paths[0].trim();
            if (last.contains("(") && ((args2 = JavaParserUtil.getMethodInvocationParameters(last)) == null || !args2.isEmpty())) continue;
            buffer.append(last);
            tmp.add(buffer.toString());
            int max = paths.length - 1;
            for (int i = 1; i < max && (args = JavaParserUtil.getMethodInvocationParameters(s = ((String)paths[i]).trim())) != null && args.isEmpty(); ++i) {
                buffer.append(".").append(s);
                last = buffer.toString();
                tmp.add(last);
            }
            linkedHashSet.addAll(tmp);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Detected requirements : " + linkedHashSet));
        }
        return linkedHashSet;
    }

    public static String getMethodInvocationParameters(String code) {
        int openIndex = code.indexOf("(");
        int closeIndex = code.lastIndexOf(")");
        if (openIndex > -1 && closeIndex > -1) {
            if (closeIndex == openIndex + 1) {
                return "";
            }
            return code.substring(openIndex + 1, closeIndex - 1).trim();
        }
        return null;
    }

    public static String getPropertyNameFromMethod(String code) {
        int openIndex = code.indexOf("(");
        if (openIndex != -1) {
            code = code.substring(0, openIndex);
        }
        int index = 3;
        if (code.startsWith("is")) {
            index = 2;
        }
        code = code.substring(index);
        code = Introspector.decapitalize(code);
        return code;
    }

    public static void scanForExpressions(SimpleNode node, SimpleNode lastExpressionNode, Map<SimpleNode, List<SimpleNode>> store, List<SimpleNode> literals, Map<SimpleNode, List<SimpleNode>> casts) {
        List<SimpleNode> simpleNodeList;
        String nodeExpression = node.getText().trim();
        if (log.isTraceEnabled()) {
            log.trace((Object)("node " + node.getId() + " nbChilds : " + node.jjtGetNumChildren() + " : " + nodeExpression));
        }
        if (node.getId() == 66) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("detected literal " + nodeExpression + " for last expression " + lastExpressionNode.getText()));
            }
            literals.add(lastExpressionNode);
            return;
        }
        if (node.getId() == 61) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("detected cast " + nodeExpression + " for last expression " + lastExpressionNode.getText()));
            }
            simpleNodeList = casts.computeIfAbsent(lastExpressionNode, k -> new ArrayList());
            simpleNodeList.add(node);
        }
        if (node.getId() == 62) {
            store.computeIfAbsent(node, k -> new ArrayList());
            if (lastExpressionNode != null) {
                simpleNodeList = store.get(lastExpressionNode);
                if (simpleNodeList == null) {
                    simpleNodeList = new ArrayList<SimpleNode>();
                    store.put(node, simpleNodeList);
                }
                simpleNodeList.add(node);
            }
            lastExpressionNode = node;
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            JavaParserUtil.scanForExpressions(node.getChild(i), lastExpressionNode, store, literals, casts);
        }
    }
}

