/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: TokenMgrError.java 2228 2011-02-19 21:56:44Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.6/jaxx-compiler/src/main/java/jaxx/compiler/java/parser/TokenMgrError.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
/* Generated By:JavaCC: Do not edit this line. TokenMgrError.java Version 3.0 */

package jaxx.compiler.java.parser;

public class TokenMgrError extends Error {
    /*
    * Ordinals for various reasons why an Error of this type can be thrown.
    */

    /** Lexical error occured. */
    static final int LEXICAL_ERROR = 0;

    /** An attempt wass made to create a second instance of a static token manager. */
    static final int STATIC_LEXER_ERROR = 1;

    /** Tried to change to an invalid lexical state. */
    static final int INVALID_LEXICAL_STATE = 2;

    /** Detected (and bailed out of) an infinite loop in the token manager. */
    static final int LOOP_DETECTED = 3;

    /**
     * Indicates the reason why the exception is thrown. It will have
     * one of the above 4 values.
     */
    int errorCode;
    private static final long serialVersionUID = -9131500865453532454L;

    /**
     * Replaces unprintable characters by their espaced (or unicode escaped)
     * equivalents in the given string
     *
     * @param str text to treate
     * @return the treated text
     */
    protected static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        char ch;
        for (int i = 0; i < str.length(); i++) {
            switch (str.charAt(i)) {
                case 0:
                    continue;
                case '\b':
                    retval.append("\\b");
                    continue;
                case '\t':
                    retval.append("\\t");
                    continue;
                case '\n':
                    retval.append("\\n");
                    continue;
                case '\f':
                    retval.append("\\f");
                    continue;
                case '\r':
                    retval.append("\\r");
                    continue;
                case '\"':
                    retval.append("\\\"");
                    continue;
                case '\'':
                    retval.append("\\\'");
                    continue;
                case '\\':
                    retval.append("\\\\");
                    continue;
                default:
                    if ((ch = str.charAt(i)) < 0x20 || ch > 0x7e) {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u").append(s.substring(s.length() - 4, s.length()));
                    } else {
                        retval.append(ch);
                    }
            }
        }
        return retval.toString();
    }

    /**
     * @param EOFSeen     : indicates if EOF caused the lexicl error
     * @param lexState    : lexical state in which this error occured
     * @param errorLine   : line number when the error occured
     * @param errorColumn : column number when the error occured
     * @param errorAfter  : prefix that was seen before this error occured
     * @param curChar     : the offending character
     *                    Note: You can customize the lexical error message by modifying this method.
     * @return a detailed message for the Error when it is thrown by the
     *         token manager to indicate a lexical error.
     */
    protected static String LexicalError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar) {
        return "Lexical error at line " +
                errorLine + ", column " +
                errorColumn + ".  Encountered: " +
                (EOFSeen ? "<EOF> " : "\"" + addEscapes(String.valueOf(curChar)) + "\"" + " (" + (int) curChar + "), ") +
                "after : \"" + addEscapes(errorAfter) + "\"";
    }

    /**
     * You can also modify the body of this method to customize your error messages.
     * For example, cases like LOOP_DETECTED and INVALID_LEXICAL_STATE are not
     * of end-users concern, so you can return something like :
     * <p/>
     * "Internal Error : Please file a bug report .... "
     * <p/>
     * from this method for such cases in the release version of your parser.
     */
    @Override
    public String getMessage() {
        return super.getMessage();
    }

    /*
    * Constructors of various flavors follow.
    */

    public TokenMgrError() {
    }

    public TokenMgrError(String message, int reason) {
        super(message);
        errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
        this(LexicalError(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
    }
}
