/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.swing;

import java.io.IOException;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.DefaultComponentHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JTreeHandler
extends DefaultComponentHandler {
    public JTreeHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, JTree.class);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        this.addProxyEventInfo("getSelectionCount", TreeSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectionPath", TreeSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectionPaths", TreeSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectionRows", TreeSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectionValue", TreeSelectionListener.class, "selectionModel");
    }

    @Override
    public void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        if (children.getLength() > 0) {
            compiler.reportError("JTree does not accept childs");
            throw new CompilerException("JTree does not accept childs");
        }
    }
}

