/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.reflect.resolvers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.ClassDescriptorResolver;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.runtime.JAXXObjectDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassDescriptorResolverFromJavaClass
extends ClassDescriptorResolver {
    private static final Log log = LogFactory.getLog(ClassDescriptorResolverFromJavaClass.class);

    public ClassDescriptorResolverFromJavaClass() {
        super(ClassDescriptorHelper.ResolverType.JAVA_CLASS);
    }

    @Override
    public ClassDescriptor resolvDescriptor(String className, URL source) throws ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("for source " + className));
        }
        Class<?> javaClass = ClassDescriptorHelper.getClass(className, this.getClassLoader());
        String name = javaClass.getName();
        Package p = javaClass.getPackage();
        String packageName = p != null ? p.getName() : null;
        Class<?> superclass = javaClass.getSuperclass();
        String superclassName = superclass != null ? superclass.getName() : null;
        Class<?>[] interfaces = javaClass.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = interfaces[i].getName();
        }
        boolean isInterface = javaClass.isInterface();
        boolean isArray = javaClass.isArray();
        String componentTypeName = isArray ? javaClass.getComponentType().getName() : null;
        ClassLoader classLoader = javaClass.getClassLoader();
        Constructor<?>[] javaConstructors = javaClass.getConstructors();
        MethodDescriptor[] constructors = new MethodDescriptor[javaConstructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            constructors[i] = ClassDescriptorHelper.createMethodDescriptor(javaConstructors[i], javaClass.getClassLoader());
        }
        Method[] javaMethods = javaClass.getMethods();
        MethodDescriptor[] methods = new MethodDescriptor[javaMethods.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = ClassDescriptorHelper.createMethodDescriptor(javaMethods[i], javaClass.getClassLoader());
        }
        Field[] javaFields = javaClass.getFields();
        FieldDescriptor[] fields = new FieldDescriptor[javaFields.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = ClassDescriptorHelper.createFieldDescriptor(javaFields[i], javaClass.getClassLoader());
        }
        Field[] javaDeclaredFields = javaClass.getDeclaredFields();
        FieldDescriptor[] declaredFields = new FieldDescriptor[javaDeclaredFields.length];
        for (int i = 0; i < declaredFields.length; ++i) {
            declaredFields[i] = ClassDescriptorHelper.createFieldDescriptor(javaDeclaredFields[i], javaClass.getClassLoader());
        }
        JAXXObjectDescriptor jaxxObjectDescriptor = ClassDescriptorHelper.getJAXXObjectDescriptor(javaClass);
        return new JavaClassClassDescriptor(javaClass, name, packageName, superclassName, interfaceNames, isInterface, isArray, componentTypeName, jaxxObjectDescriptor, classLoader, constructors, methods, fields, declaredFields);
    }

    private class JavaClassClassDescriptor
    extends ClassDescriptor {
        private final Class<?> javaClass;

        public JavaClassClassDescriptor(Class<?> javaClass, String name, String packageName, String superclassName, String[] interfaceNames, boolean anInterface, boolean array, String componentTypeName, JAXXObjectDescriptor jaxxObjectDescriptor, ClassLoader classLoader, MethodDescriptor[] constructors, MethodDescriptor[] methods, FieldDescriptor[] fields, FieldDescriptor[] declaredFields) {
            super(ClassDescriptorResolverFromJavaClass.this.getResolverType(), name, packageName, superclassName, interfaceNames, anInterface, array, componentTypeName, jaxxObjectDescriptor, classLoader, constructors, methods, fields, declaredFields);
            this.javaClass = javaClass;
        }

        @Override
        public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
            try {
                Class[] parameterTypeClasses = new Class[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameterTypeClasses[i] = Class.forName(parameterTypes[i].getName());
                }
                return ClassDescriptorHelper.createMethodDescriptor(this.javaClass.getDeclaredMethod(name, parameterTypeClasses), this.javaClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

