/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags;

import java.io.File;
import java.io.IOException;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.css.StylesheetHelper;
import jaxx.compiler.tags.TagHandler;
import jaxx.runtime.css.Stylesheet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StyleHandler
implements TagHandler {
    public static final String TAG_NAME = "style";
    public static final String SOURCE_ATTRIBUTE = "source";

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        boolean source = false;
        NamedNodeMap attributes = tag.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getName();
            String attrValue = attribute.getValue();
            if (name.equals(SOURCE_ATTRIBUTE)) {
                source = true;
                File styleFile = new File(compiler.getBaseDir(), attrValue.replace('/', File.separatorChar));
                if (!styleFile.exists()) {
                    compiler.reportError("stylesheet file not found: " + styleFile);
                    continue;
                }
                compiler.registerStyleSheetFile(styleFile);
                continue;
            }
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            throw new UnsupportedAttributeException(name);
        }
        StringBuilder style = new StringBuilder();
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    compiler.reportError("<style> tag may not contain child elements: " + tag);
                }
                case 3: 
                case 4: {
                    style.append(((Text)child).getData());
                }
            }
        }
        String styleString = style.toString().trim();
        if (styleString.length() > 0) {
            if (source) {
                compiler.reportError("<style> tag has both a source attribute and an inline stylesheet");
            }
            Stylesheet stylesheet = StylesheetHelper.processStylesheet(style.toString());
            compiler.registerStylesheet(stylesheet);
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
    }
}

