/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.binding.writers;

import java.util.List;
import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.binding.DataListener;
import jaxx.compiler.binding.JavaParserUtil;
import jaxx.compiler.binding.writers.AbstractJAXXBindingWriter;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaElementFactory;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;

public class SimpleJAXXObjectBindingWriter
extends AbstractJAXXBindingWriter<SimpleJAXXObjectBinding> {
    protected boolean used;

    public SimpleJAXXObjectBindingWriter() {
        super(SimpleJAXXObjectBinding.class);
    }

    @Override
    public boolean accept(DataBinding binding) {
        DataListener[] trackers = binding.getTrackers();
        if (trackers.length > 0) {
            for (DataListener tracker : trackers) {
                if (tracker.getObjectCode() == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getConstructorParams(DataBinding binding, DataListener[] trackers) {
        StringBuilder addBuffer = new StringBuilder();
        addBuffer.append("this, ");
        addBuffer.append(binding.getConstantId());
        addBuffer.append(", true");
        for (DataListener tracker : trackers) {
            String symbol = tracker.getSymbol();
            String name = symbol.substring(symbol.indexOf(".") + 1);
            if (JavaParserUtil.getMethodInvocationParameters(name) != null) {
                name = JavaParserUtil.getPropertyNameFromMethod(name);
            }
            addBuffer.append(" ,\"").append(name).append("\"");
        }
        return addBuffer.toString();
    }

    @Override
    public void write(DataBinding binding, JavaFileGenerator generator, StringBuilder buffer) {
        DataListener[] trackers = binding.getTrackers();
        List<JavaMethod> bMethods = binding.getMethods();
        JavaMethod method = JavaElementFactory.newMethod(1, "void", "processDataBinding", binding.getProcessDataBinding(), true, new JavaArgument[0]);
        bMethods.add(0, method);
        this.writeInvocationMethod(binding, trackers, generator, buffer, bMethods);
    }
}

