/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tasks;

import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.tasks.JAXXEngineTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompileSecondPassTask
extends JAXXEngineTask {
    private static final Log log = LogFactory.getLog(CompileSecondPassTask.class);
    public static final String TASK_NAME = "CompileSecondPass";

    public CompileSecondPassTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        JAXXCompilerFile[] files;
        boolean success = true;
        boolean isVerbose = engine.isVerbose();
        this.checkAllFilesCompiled(engine);
        for (JAXXCompilerFile jaxxFile : files = engine.getCompiledFiles()) {
            String className = jaxxFile.getClassName();
            if (isVerbose) {
                log.info((Object)("start " + className));
            }
            JAXXCompiler compiler = jaxxFile.getCompiler();
            this.addStartProfileTime(engine, compiler);
            if (log.isDebugEnabled()) {
                log.debug((Object)("runInitializers for " + className));
            }
            if (!compiler.isFailed()) {
                compiler.runInitializers();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("compile second pass for " + className));
            }
            compiler.compileSecondPass();
            this.addEndProfileTime(engine, compiler);
            if (log.isDebugEnabled()) {
                log.debug((Object)("done with result [" + !compiler.isFailed() + "] for " + className));
            }
            if (!compiler.isFailed()) continue;
            success = false;
        }
        return success;
    }
}

