/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.reflect.resolvers;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.JAXXFactory;
import jaxx.compiler.SymbolTable;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.ClassDescriptorResolver;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassDescriptorResolverFromJaxxFile
extends ClassDescriptorResolver {
    private static final Log log = LogFactory.getLog(ClassDescriptorResolverFromJaxxFile.class);

    public ClassDescriptorResolverFromJaxxFile() {
        super(ClassDescriptorHelper.ResolverType.JAXX_FILE);
    }

    @Override
    public ClassDescriptor resolvDescriptor(String className, URL source) throws ClassNotFoundException {
        ClassDescriptor[] superclassInterfaces;
        JAXXEngine engine = JAXXFactory.getEngine();
        JAXXCompiler compiler = engine.getJAXXCompiler(className);
        SymbolTable symbolTable = compiler.getSymbolTable();
        if (symbolTable == null) {
            throw new CompilerException("Internal error: no symbol table was generated for class '" + className + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("for compiler " + compiler.getOutputClassName()));
        }
        ClassLoader classLoader = this.getClassLoader();
        ClassDescriptor superclass = ClassDescriptorHelper.getClassDescriptor(symbolTable.getSuperclassName(), classLoader);
        ArrayList constructors = new ArrayList();
        List<MethodDescriptor> publicMethods = symbolTable.getScriptMethods();
        List<FieldDescriptor> publicFields = symbolTable.getScriptFields();
        Iterator<MethodDescriptor> methods = publicMethods.iterator();
        while (methods.hasNext()) {
            MethodDescriptor method = methods.next();
            if (Modifier.isPublic(method.getModifiers())) continue;
            methods.remove();
        }
        Iterator<FieldDescriptor> fields = publicFields.iterator();
        while (fields.hasNext()) {
            FieldDescriptor field = fields.next();
            if (Modifier.isPublic(field.getModifiers())) continue;
            fields.remove();
        }
        HashSet<String> interfaces = new HashSet<String>();
        if (symbolTable.getInterfaces() != null) {
            for (String anInterface : symbolTable.getInterfaces()) {
                int genericIndex = anInterface.indexOf("<");
                if (genericIndex > -1) {
                    anInterface = anInterface.substring(0, genericIndex);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getting interface " + anInterface + " descriptor for class " + className));
                }
                interfaces.add(anInterface);
                ClassDescriptor interfaceclass = ClassDescriptorHelper.getClassDescriptor(anInterface, classLoader);
                publicMethods.addAll(Arrays.asList(interfaceclass.getMethodDescriptors()));
                publicFields.addAll(Arrays.asList(interfaceclass.getFieldDescriptors()));
            }
        }
        publicMethods.addAll(Arrays.asList(superclass.getMethodDescriptors()));
        publicFields.addAll(Arrays.asList(superclass.getFieldDescriptors()));
        int dotPos = className.lastIndexOf(".");
        String packageName = dotPos != -1 ? className.substring(0, dotPos) : null;
        for (ClassDescriptor superclassInterface : superclassInterfaces = superclass.getInterfaces()) {
            interfaces.add(superclassInterface.getName());
        }
        interfaces.add(JAXXObject.class.getName());
        return new JaxxFileClassDescriptor(compiler, className, packageName, interfaces, classLoader, constructors.toArray(new MethodDescriptor[constructors.size()]), publicMethods.toArray(new MethodDescriptor[publicMethods.size()]), publicFields.toArray(new FieldDescriptor[publicFields.size()]));
    }

    private class JaxxFileClassDescriptor
    extends ClassDescriptor {
        private final JAXXCompiler compiler;

        public JaxxFileClassDescriptor(JAXXCompiler compiler, String className, String packageName, Set<String> interfaces, ClassLoader classLoader, MethodDescriptor[] constructors, MethodDescriptor[] publicMethods, FieldDescriptor[] publicFields) {
            super(ClassDescriptorResolverFromJaxxFile.this.getResolverType(), className, packageName, compiler.getSymbolTable().getSuperclassName(), interfaces.toArray(new String[interfaces.size()]), false, false, null, null, classLoader, constructors, publicMethods, publicFields);
            this.compiler = compiler;
        }

        @Override
        public FieldDescriptor getDeclaredFieldDescriptor(String name) throws NoSuchFieldException {
            String type = this.compiler.getSymbolTable().getClassTagIds().get(name);
            if (type != null) {
                return new FieldDescriptor(name, 4, type, this.compiler.getClassLoader());
            }
            throw new NoSuchFieldException(name);
        }

        @Override
        public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
            throw new NoSuchMethodException(name);
        }

        @Override
        public JAXXObjectDescriptor getJAXXObjectDescriptor() {
            return this.compiler.getJAXXObjectDescriptor();
        }
    }
}

