/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.decorators;

import java.util.Map;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.compiler.script.ScriptInitializer;
import jaxx.compiler.types.TypeManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCompiledObjectDecorator
implements CompiledObjectDecorator {
    protected static final Log log = LogFactory.getLog(DefaultCompiledObjectDecorator.class);

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) {
        boolean override;
        if (object instanceof ScriptInitializer) {
            return;
        }
        String fqn = JAXXCompiler.getCanonicalName(object);
        String id = object.getId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("finalize " + id));
        }
        if (override = object.isOverride()) {
            if (object.isOverrideType()) {
                String methodName = object.getGetterName();
                String body = "return (" + fqn + ") super." + methodName + "();";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add specialized getter " + methodName + " : " + body));
                }
                JavaMethod getter = JavaFileGenerator.newMethod(1, fqn, methodName, body, true, new JavaArgument[0]);
                javaFile.addMethod(getter);
            }
        } else {
            JavaField field;
            int access;
            int n = access = id.startsWith("$") ? 2 : 4;
            if (root.equals(object)) {
                field = JavaFileGenerator.newField(access, className, id, false, "this");
                javaFile.addSimpleField(field);
            } else {
                field = JavaFileGenerator.newField(access, fqn, id, override);
                javaFile.addField(field, object.isJavaBean());
            }
        }
        if (compiler.inlineCreation(object) || root.equals(object)) {
            return;
        }
        String code = this.getCreationCode(compiler, object);
        if (code != null) {
            JavaMethod javaMethod = JavaFileGenerator.newMethod(4, "void", object.getCreationMethodName(), code, override, new JavaArgument[0]);
            javaFile.addMethod(javaMethod);
        }
    }

    @Override
    public String getCreationCode(JAXXCompiler compiler, CompiledObject object) throws CompilerException {
        if (object instanceof ScriptInitializer) {
            throw new IllegalStateException("A script initializer can not come in getCreationcode method!");
        }
        String eol = JAXXCompiler.getLineSeparator();
        StringBuffer result = new StringBuffer();
        StringBuilder init = new StringBuilder();
        if (compiler.getRootObject().equals(object) || compiler.inlineCreation(object)) {
            result.append("// inline creation of ").append(object.getId());
        }
        if (object.isJavaBean() && object.getJavaBeanInitCode() != null) {
            init.append(object.getJavaBeanInitCode());
        } else if (object.getInitializer() != null) {
            init.append(object.getInitializer());
        }
        boolean addToObjectMap = true;
        String id = TypeManager.getJavaCode(object.getId());
        String constructorParams = object.getConstructorParams();
        if (object.isOverride() && init.length() == 0 && constructorParams == null) {
            addToObjectMap = false;
        }
        if (addToObjectMap && init.length() == 0) {
            String canonicalName = JAXXCompiler.getCanonicalName(object);
            init.append("new ").append(canonicalName).append("(");
            if (constructorParams != null) {
                init.append(constructorParams);
            }
            init.append(")");
        }
        String superCall = "super." + object.getCreationMethodName() + "();";
        if (addToObjectMap) {
            result.append(eol);
            result.append("$objectMap.put(");
            result.append(id);
            result.append(", ");
            result.append(object.getId()).append(" = ");
            result.append((CharSequence)init);
            result.append(");");
            result.append(eol);
        } else if (object.isOverride()) {
            result.append(superCall);
        }
        String initCode = object.getInitializationCode(compiler);
        if (initCode != null && initCode.length() > 0) {
            result.append(eol).append(initCode);
        }
        this.addClientProperties(object, result, eol);
        String code = result.toString();
        if (!compiler.inlineCreation(object) && object.isOverride() && superCall.equals(code.trim())) {
            return null;
        }
        return code;
    }

    @Override
    public String createCompleteSetupMethod(JAXXCompiler compiler, CompiledObject object, JavaFile javaFile) {
        String additionCode;
        StringBuffer code = new StringBuffer();
        String eol = JAXXCompiler.getLineSeparator();
        if (object.getId().startsWith("$")) {
            additionCode = object.getAdditionCode();
            if (!additionCode.isEmpty()) {
                code.append("// inline complete setup of ");
                code.append(object.getId());
                code.append(eol);
                code.append(additionCode);
            }
        } else {
            additionCode = object.getAdditionCode();
            if (additionCode.length() > 0) {
                code.append(object.getAdditionMethodName()).append("();").append(eol);
                additionCode = "if (!allComponentsCreated) {" + eol + "    return;" + eol + "}" + eol + additionCode;
                javaFile.addMethod(JavaFileGenerator.newMethod(4, "void", object.getAdditionMethodName(), additionCode, false, new JavaArgument[0]));
            }
        }
        String result = code.toString();
        return result;
    }

    @Override
    public boolean createInitializer(JAXXCompiler compiler, CompiledObject root, CompiledObject object, StringBuffer code, boolean lastWasMethodCall) {
        String eol = JAXXCompiler.getLineSeparator();
        if (object instanceof ScriptInitializer) {
            code.append(object.getInitializationCode(compiler));
            return lastWasMethodCall;
        }
        if (root.equals(object)) {
            String rootCode = root.getInitializationCode(compiler);
            if (rootCode != null && rootCode.length() > 0) {
                code.append("// inline creation of ");
                code.append(object.getId());
                code.append(eol);
                code.append(rootCode);
                this.addClientProperties(object, code, eol);
                code.append(eol);
            }
        } else if (!object.isOverride()) {
            if (compiler.inlineCreation(object)) {
                if (lastWasMethodCall) {
                    lastWasMethodCall = false;
                }
                code.append(this.getCreationCode(compiler, object));
            } else {
                code.append(object.getCreationMethodName()).append("();");
                code.append(eol);
                lastWasMethodCall = true;
            }
        }
        return lastWasMethodCall;
    }

    protected void addClientProperties(CompiledObject object, StringBuffer code, String eol) {
        if (object.hasClientProperties()) {
            for (Map.Entry<String, String> entry : object.getClientProperties().entrySet()) {
                code.append(object.getJavaCode());
                code.append(".putClientProperty(\"");
                code.append(entry.getKey());
                code.append("\", ");
                code.append(entry.getValue());
                code.append(");");
                code.append(eol);
            }
        }
    }
}

