/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.util.Arrays;
import java.util.List;
import jaxx.compiler.JAXXCompiler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nHelper {
    protected static final Log log = LogFactory.getLog(I18nHelper.class);
    public static final List<String> I18N_ATTRIBUTES = Arrays.asList("text", "title", "toolTipText");

    public static boolean isI18nableAttribute(String attributeName, JAXXCompiler compiler) {
        return compiler.getConfiguration().isI18nable() && I18nHelper.isI18nAttribute(attributeName);
    }

    public static boolean isI18nAttribute(String attributeName) {
        return I18N_ATTRIBUTES.contains(attributeName);
    }

    public static String addI18nInvocation(String widgetId, String attributeName, String attributeValueCode, JAXXCompiler compiler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" try i18n support for [" + widgetId + ":" + attributeName + "] : " + attributeValueCode));
        }
        if (attributeValueCode.contains("_(") && attributeValueCode.contains(")")) {
            compiler.reportWarning("\n\tjaxx supports i18n, no need to add explicit call to I18n._ for attribute '" + attributeName + "' in component '" + widgetId + "' : [" + attributeValueCode + "]");
        } else {
            attributeValueCode = "_(" + attributeValueCode + ")";
        }
        return attributeValueCode;
    }
}

