/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: SimpleNode.java 1847 2010-04-16 12:27:48Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.1/jaxx-compiler/src/main/java/jaxx/compiler/java/parser/SimpleNode.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
/* Generated By:JJTree: Do not edit this line. SimpleNode.java */


package jaxx.compiler.java.parser;

import jaxx.compiler.reflect.ClassDescriptor;

public class SimpleNode implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    public Token firstToken;
    public Token lastToken;
    private ClassDescriptor javaType;


    public SimpleNode(int i) {
        id = i;
    }

    public SimpleNode(JavaParser p, int i) {
        this(i);
        parser = p;
    }


    public int getId() {
        return id;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        parent = n;
    }

    public Node jjtGetParent() {
        return parent;
    }

    public SimpleNode getParent() {
        return (SimpleNode) parent;
    }


    public ClassDescriptor getJavaType() {
        return javaType;
    }


    public void setJavaType(ClassDescriptor javaType) {
        this.javaType = javaType;
    }

    public void jjtAddChild(Node n, int i) {
        if (children == null) {
            children = new Node[i + 1];
        } else if (i >= children.length) {
            Node c[] = new Node[i + 1];
            System.arraycopy(children, 0, c, 0, children.length);
            children = c;
        }
        children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return children[i];
    }

    public SimpleNode getChild(int i) {
        return (SimpleNode) children[i];
    }

    public int jjtGetNumChildren() {
        return (children == null) ? 0 : children.length;
    }

    /* You can override these two methods in subclasses of SimpleNode to
customize the way the node appears when the tree is dumped.  If
your output uses more than one line you should override
toString(String), otherwise overriding toString() is probably all
you need to do. */

    @Override
    public String toString() {
        return getClass().getName() + "[" + getText() + "]";
    }

    public String toString(String prefix) {
        return prefix + toString();
    }

    /* Override this method if you want to customize how the node dumps
 out its children. */

    public void dump(String prefix) {
        System.out.println(toString(prefix));
        if (children != null) {
            for (Node aChildren : children) {
                SimpleNode n = (SimpleNode) aChildren;
                if (n != null) {
                    n.dump(prefix + " ");
                }
            }
        }
    }

    private void appendSpecialTokens(StringBuffer s, Token st) {
        if (st != null) {
            appendSpecialTokens(s, st.specialToken);
            s.append(st.image);
        }
    }


    /** @return the text of the tokens comprising this node. */
    public String getText() {
        StringBuffer text = new StringBuffer();
        Token t = firstToken;
        while (t != null) {
            appendSpecialTokens(text, t.specialToken);
            text.append(t.image);
            if (t == lastToken)
                break;
            t = t.next;
        }

        return text.toString();
    }
}

