/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.decorators;

import java.util.Map;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.script.ScriptInitializer;

public class DefaultCompiledObjectDecorator
implements CompiledObjectDecorator {
    @Override
    public String getName() {
        return "default";
    }

    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) {
        if (!object.isOverride() && !(object instanceof ScriptInitializer)) {
            int access;
            String id = object.getId();
            int n = access = id.startsWith("$") ? 2 : 4;
            if (object == root) {
                javaFile.addSimpleField(JavaFileGenerator.newField(access, className, id, false, "this"));
            } else {
                javaFile.addField(JavaFileGenerator.newField(access, JAXXCompiler.getCanonicalName(object), id, object.isOverride()), object.isJavaBean());
            }
        }
        if (!compiler.inlineCreation(object) && object != root) {
            javaFile.addMethod(JavaFileGenerator.newMethod(4, "void", object.getCreationMethodName(), this.getCreationCode(compiler, object), object.isOverride(), new JavaArgument[0]));
        }
    }

    @Override
    public String getCreationCode(JAXXCompiler compiler, CompiledObject object) throws CompilerException {
        if (object instanceof ScriptInitializer) {
            return object.getInitializationCode(compiler);
        }
        String eol = JAXXCompiler.getLineSeparator();
        StringBuffer result = new StringBuffer();
        if (compiler.getRootObject() == object || compiler.inlineCreation(object)) {
            result.append("// inline creation of " + object.getId());
        }
        if (object.isOverride() && object.getOverrideType() == object.getObjectClass()) {
            result.append("super.").append(object.getCreationMethodName()).append("();");
        } else {
            String init = object.getId() + " = ";
            if (object.isJavaBean() && object.getJavaBeanInitCode() != null) {
                init = init + object.getJavaBeanInitCode();
            } else if (object.getInitializer() != null) {
                init = init + object.getInitializer();
            } else {
                String canonicalName = JAXXCompiler.getCanonicalName(object);
                init = init + "new " + canonicalName + "(";
                String constructorParams = object.getConstructorParams();
                if (constructorParams != null) {
                    init = init + constructorParams;
                }
                init = init + ")";
            }
            result.append(eol);
            result.append("$objectMap.put(").append(compiler.getJavaCode(object.getId())).append(", ").append(init).append(");");
        }
        result.append(eol);
        String initCode = object.getInitializationCode(compiler);
        if (initCode != null && initCode.length() > 0) {
            result.append(initCode);
        }
        this.addClientProperties(object, result, eol);
        return result.toString();
    }

    @Override
    public String createCompleteSetupMethod(JAXXCompiler compiler, CompiledObject object, JavaFile javaFile, StringBuffer initDataBindings) {
        String additionCode;
        StringBuffer code = new StringBuffer();
        String eol = JAXXCompiler.getLineSeparator();
        if (object.getId().startsWith("$")) {
            additionCode = object.getAdditionCode();
            if (!additionCode.isEmpty()) {
                code.append("// inline complete setup of " + object.getId()).append(eol);
                code.append(additionCode);
            }
        } else {
            additionCode = object.getAdditionCode();
            if (additionCode.length() > 0) {
                code.append(object.getAdditionMethodName()).append("();").append(eol);
                additionCode = "if (!allComponentsCreated) {" + eol + "    return;" + eol + "}" + eol + additionCode;
                javaFile.addMethod(JavaFileGenerator.newMethod(4, "void", object.getAdditionMethodName(), additionCode, false, new JavaArgument[0]));
            }
        }
        String result = code.toString();
        return result;
    }

    @Override
    public boolean createInitializer(JAXXCompiler compiler, CompiledObject root, CompiledObject object, StringBuffer code, boolean lastWasMethodCall) {
        String eol = JAXXCompiler.getLineSeparator();
        if (object == root) {
            String rootCode = root.getInitializationCode(compiler);
            if (rootCode != null && rootCode.length() > 0) {
                code.append("// inline creation of " + object.getId()).append(eol);
                code.append(rootCode);
                this.addClientProperties(object, code, eol);
                code.append(eol);
            }
        } else if (!object.isOverride()) {
            if (compiler.inlineCreation(object)) {
                if (lastWasMethodCall) {
                    lastWasMethodCall = false;
                }
                code.append(this.getCreationCode(compiler, object));
            } else {
                code.append(object.getCreationMethodName()).append("();");
                code.append(eol);
                lastWasMethodCall = true;
            }
        }
        return lastWasMethodCall;
    }

    protected void addClientProperties(CompiledObject object, StringBuffer code, String eol) {
        if (object.hasClientProperties()) {
            for (Map.Entry<String, String> entry : object.getClientProperties().entrySet()) {
                code.append(object.getJavaCode() + ".putClientProperty(\"" + entry.getKey() + "\", " + entry.getValue() + ");").append(eol);
            }
        }
    }
}

