package org.nuiton.jaxx.application.swing.tab;

/*
 * #%L
 * JAXX :: Application Swing
 * $Id: CustomTab.java 2783 2014-02-04 07:27:32Z tchemit $
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Code Lutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.BeanUtil;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import static org.nuiton.i18n.I18n.t;

/**
 * Custom tab component which adds a * in the end of the title
 * when the content is modified.
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.8
 */
public class CustomTab extends JPanel {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(CustomTab.class);

    protected TabContentModel model;

    protected JLabel title = new JLabel();

    public TabContentModel getModel() {
        return model;
    }

    public CustomTab(TabContentModel model) {
        this.model = model;
        try {
            BeanUtil.addPropertyChangeListener(
                    new PropertyChangeListener() {

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            updateTitle();
                        }
                    }, this.model);

        } catch (Exception ex) {
            log.error("Error while adding the listener to the model modifications", ex);
        }

        setBackground(null);

        updateTitle();
        String actionIcon = model.getIcon();
        if (actionIcon != null) {
            title.setIcon(SwingUtil.createActionIcon(actionIcon));
        }
        add(title);
    }

    @Override
    public void setBackground(Color bg) {
        if (bg == null) {
            bg = new Color(0, 0, 0, 0);
        }
        super.setBackground(bg);
        revalidate();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (title != null) {
            title.setForeground(fg);
        }
    }

    protected void updateTitle() {
        Font f = UIManager.getDefaults().getFont("Label.font");
        String titleValue = t(model.getTitle());

        int style;
        if (model.isModify()) {
            style = Font.BOLD;
            titleValue += "*";

        } else if (model.isEmpty()) {
            style = Font.ITALIC;

        } else {
            style = Font.PLAIN;
        }

        title.setText(titleValue);
        title.setFont(f.deriveFont(style));
    }

}
