/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.tags;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.tags.TagHandler;

public class TagManager {
    public static final String GUIX_NAMESPACE = "org.nuiton.guix.*";
    protected static final Log log = LogFactory.getLog(TagManager.class);
    protected static Map<String, Class> guixClassHandlers = new HashMap<String, Class>();
    private static Map<String, String> defaultNamespaces = new HashMap<String, String>();

    private TagManager() {
    }

    public static void registerDefaultNamespace(String tag, String namespace) {
        if (defaultNamespaces.containsKey(tag) && defaultNamespaces.get(tag) != null && !defaultNamespaces.get(tag).equals(namespace)) {
            defaultNamespaces.put(tag, null);
        } else {
            defaultNamespaces.put(tag, namespace);
        }
    }

    public static void registerGuixClassHandler(String className, Class clazz) {
        guixClassHandlers.put(className.toUpperCase(), clazz);
    }

    public static TagHandler getGuixClassHandler(String className) {
        block9: {
            if (guixClassHandlers.get(className.toUpperCase()) != null) {
                try {
                    return (TagHandler)guixClassHandlers.get(className.toUpperCase()).newInstance();
                }
                catch (InstantiationException eee) {
                    break block9;
                }
                catch (IllegalAccessException eee) {
                    break block9;
                }
            }
            for (Class clazz : guixClassHandlers.values()) {
                try {
                    TagHandler th = (TagHandler)clazz.newInstance();
                    if (!th.getClassToGenerate().getName().equals(className)) continue;
                    return th;
                }
                catch (InstantiationException eee) {
                }
                catch (IllegalAccessException eee) {
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
        return null;
    }

    public static String resolveClassName(String name) {
        if (name.endsWith("[]")) {
            return TagManager.resolveClassName(name.substring(0, name.length() - 2)) + "[]";
        }
        if (name.indexOf("<") != -1) {
            name = name.substring(0, name.indexOf("<"));
        }
        if ((name = name.intern()).equals("boolean") || name.equals("byte") || name.equals("short") || name.equals("int") || name.equals("long") || name.equals("float") || name.equals("double") || name.equals("char")) {
            return name;
        }
        if (name.equals("Boolean") || name.equals("Byte") || name.equals("Short") || name.equals("Integer") || name.equals("String") || name.equals("Long") || name.equals("Float") || name.equals("Double") || name.equals("Character")) {
            return "java.lang." + name;
        }
        if (guixClassHandlers.containsKey(name)) {
            return name;
        }
        if (name.lastIndexOf(46) >= 0) {
            return name;
        }
        return null;
    }
}

