/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.tags;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.css.CSSParser;
import org.nuiton.guix.css.ParseException;
import org.nuiton.guix.css.SimpleNode;
import org.nuiton.guix.model.Rule;
import org.nuiton.guix.model.Selector;
import org.nuiton.guix.model.StyleSheet;
import org.nuiton.guix.tags.TagManager;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StyleHandler {
    protected static final Log log = LogFactory.getLog(TagManager.class);
    private List<Selector> selectors = new ArrayList<Selector>();

    private String loadStyleFile(File styleFile) throws FileNotFoundException, IOException {
        int c;
        StringWriter styleBuffer = new StringWriter();
        FileReader in = new FileReader(styleFile);
        char[] readBuffer = new char[2048];
        while ((c = in.read(readBuffer)) > 0) {
            styleBuffer.write(readBuffer, 0, c);
        }
        return styleBuffer.toString();
    }

    public StyleSheet autoDetectStyleFile(File styleFile) throws IOException {
        this.selectors = new ArrayList<Selector>();
        return this.processStylesheet(this.loadStyleFile(styleFile));
    }

    public StyleSheet compileStyle(XmlPullParser xpp, File styleFile) throws IOException, XmlPullParserException {
        StyleSheet result = null;
        StringBuffer style = new StringBuffer();
        this.selectors = new ArrayList<Selector>();
        if (styleFile != null && styleFile.exists()) {
            style.append(this.loadStyleFile(styleFile));
        }
        xpp.nextToken();
        do {
            switch (xpp.getEventType()) {
                case 2: {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)("<style> tag may not contain child elements: " + xpp.getName()));
                    break;
                }
                case 4: {
                    style.append(xpp.getText());
                    xpp.nextToken();
                    break;
                }
                case 5: {
                    style.append(xpp.getText());
                    xpp.nextToken();
                    break;
                }
            }
        } while (xpp.getEventType() != 3 && xpp.getEventType() != 1 && !"style".equals(xpp.getName()));
        result = this.processStylesheet(style.toString());
        return result;
    }

    protected Selector processSelector(SimpleNode selector) {
        if (selector.getId() != 3) {
            throw new IllegalArgumentException("argument node is not a Selector");
        }
        String javaClassName = null;
        String styleClass = null;
        String pseudoClass = null;
        String id = null;
        block6: for (int i = 0; i < selector.jjtGetNumChildren(); ++i) {
            SimpleNode child = selector.getChild(i);
            switch (child.getId()) {
                case 4: {
                    if (child.getText().trim().equals("*")) continue block6;
                    javaClassName = child.getText();
                    continue block6;
                }
                case 6: {
                    styleClass = child.getText().substring(1);
                    continue block6;
                }
                case 7: {
                    pseudoClass = child.getText().substring(1);
                    continue block6;
                }
                case 5: {
                    id = child.getText().substring(1);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("unexpected child of Selector node, type=" + child.getId());
                }
            }
        }
        return new Selector(javaClassName, styleClass, pseudoClass, id);
    }

    protected Rule processRule(SimpleNode ruleNode) {
        if (ruleNode.getId() != 1) {
            throw new IllegalArgumentException("argument node is not a Rule");
        }
        SimpleNode selectorsNode = ruleNode.getChild(0);
        assert (selectorsNode.getId() == 2) : "expected node to be of type Selectors";
        ArrayList<Selector> ruleSelectors = new ArrayList<Selector>();
        for (int i = 0; i < selectorsNode.jjtGetNumChildren(); ++i) {
            SimpleNode selectorNode = selectorsNode.getChild(i);
            Selector selector = this.processSelector(selectorNode);
            ruleSelectors.add(selector);
            if (this.selectorRecorded(selector)) continue;
            this.selectors.add(selector);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 1; i < ruleNode.jjtGetNumChildren(); ++i) {
            SimpleNode declarationNode = ruleNode.getChild(i);
            if (declarationNode.getId() != 10) continue;
            String key = declarationNode.getChild(0).getText();
            SimpleNode valueNode = declarationNode.getChild(1);
            String value = valueNode.getText();
            if (valueNode.firstToken.kind == 22) {
                value = value.substring(1, value.length() - 1);
            }
            properties.put(key, value);
        }
        Rule rule = new Rule();
        rule.setSelectors(ruleSelectors);
        for (Selector selector : ruleSelectors) {
            selector.getRules().add(rule);
        }
        rule.setProperties(properties);
        return rule;
    }

    protected StyleSheet processStylesheet(String stylesheetText) throws IOException {
        CSSParser p = new CSSParser(new StringReader(stylesheetText));
        try {
            SimpleNode node = p.Stylesheet();
            ArrayList<Rule> rules = new ArrayList<Rule>();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode ruleNode = node.getChild(i);
                Rule rule = this.processRule(ruleNode);
                rules.add(rule);
            }
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.setRules(rules);
            styleSheet.setSelectors(this.selectors);
            return styleSheet;
        }
        catch (ParseException eee) {
            if (log.isWarnEnabled()) {
                log.warn((Object)eee);
            }
            return null;
        }
    }

    private boolean selectorRecorded(Selector newSelector) {
        for (Selector selector : this.selectors) {
            boolean areIdsNotNull;
            boolean areJavaClassNamesNull = newSelector.getJavaClassName() == null && selector.getJavaClassName() == null;
            boolean areJavaClassNamesNotNull = newSelector.getJavaClassName() != null && selector.getJavaClassName() != null;
            boolean areStyleClassesNull = newSelector.getStyleClass() == null && selector.getStyleClass() == null;
            boolean areStyleClassesNotNull = newSelector.getStyleClass() != null && selector.getStyleClass() != null;
            boolean arePseudoClassesNull = newSelector.getPseudoClass() == null && selector.getPseudoClass() == null;
            boolean arePseudoClassesNotNull = newSelector.getPseudoClass() != null && selector.getPseudoClass() != null;
            boolean areIdsNull = newSelector.getId() == null && selector.getId() == null;
            boolean bl = areIdsNotNull = newSelector.getId() != null && selector.getId() != null;
            if (!areJavaClassNamesNull && (!areJavaClassNamesNotNull || !newSelector.getJavaClassName().equals(selector.getJavaClassName())) || !areStyleClassesNull && (!areStyleClassesNotNull || !newSelector.getStyleClass().equals(selector.getStyleClass())) || !arePseudoClassesNull && (!arePseudoClassesNotNull || !newSelector.getPseudoClass().equals(selector.getPseudoClass())) || !areIdsNull && (!areIdsNotNull || !newSelector.getId().equals(selector.getId()))) continue;
            return true;
        }
        return false;
    }
}

