/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.tags;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.generator.JavaArgument;
import org.nuiton.guix.generator.JavaField;
import org.nuiton.guix.generator.JavaMethod;
import org.nuiton.guix.parser.JavaParser;
import org.nuiton.guix.parser.JavaParserTreeConstants;
import org.nuiton.guix.parser.SimpleNode;
import org.nuiton.guix.tags.TagManager;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ScriptHandler {
    private static final Log log = LogFactory.getLog(ScriptHandler.class);
    private static final String SWING_POSTPROCESS_FIRST_TOKEN_PATTERN = "%1$s old%2$s = %2$s;\n%2$s";
    private static final String SWING_POSTPROCESS_LAST_TOKEN_PATTERN = "%1$s;\nfirePropertyChange(\"%2$s\", old%2$s, %2$s)";

    public String loadScriptFile(File scriptFile) throws IOException {
        int c;
        StringWriter scriptBuffer = new StringWriter();
        FileReader in = new FileReader(scriptFile);
        char[] readBuffer = new char[2048];
        while ((c = in.read(readBuffer)) > 0) {
            scriptBuffer.write(readBuffer, 0, c);
        }
        return scriptBuffer.toString();
    }

    public String compileScript(XmlPullParser xpp, File scriptFile) throws IOException, XmlPullParserException {
        StringBuffer script = new StringBuffer();
        if (scriptFile != null && scriptFile.exists()) {
            script.append(this.loadScriptFile(scriptFile));
        }
        xpp.nextToken();
        script.append(xpp.getText());
        while (xpp.getEventType() != 3 || !xpp.getName().equals("script")) {
            xpp.nextToken();
        }
        return script.toString();
    }

    public static Map<ScriptPart, Object> decomposeScript(String script) {
        HashMap<ScriptPart, Object> map = new HashMap<ScriptPart, Object>();
        ArrayList imports = new ArrayList();
        StringBuffer bodyCode = new StringBuffer();
        ArrayList methods = new ArrayList();
        ArrayList fields = new ArrayList();
        StringBuffer initializers = new StringBuffer();
        JavaParser p = new JavaParser(new StringReader(script));
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            if (node == null) continue;
            Map<ScriptPart, Object> ssn = ScriptHandler.analyseScriptNode(node);
            imports.addAll((List)ssn.get((Object)ScriptPart.IMPORTS));
            bodyCode.append(ssn.get((Object)ScriptPart.BODYCODE));
            initializers.append(ssn.get((Object)ScriptPart.INITIALIZERS));
            methods.addAll((List)ssn.get((Object)ScriptPart.METHODS));
            fields.addAll((List)ssn.get((Object)ScriptPart.FIELDS));
        }
        map.put(ScriptPart.IMPORTS, imports);
        map.put(ScriptPart.BODYCODE, bodyCode.toString());
        map.put(ScriptPart.INITIALIZERS, initializers.toString());
        map.put(ScriptPart.METHODS, methods);
        map.put(ScriptPart.FIELDS, fields);
        return map;
    }

    public static String postProcessMethodBody(JavaMethod method, JavaField[] fields) {
        JavaParser p = new JavaParser(new StringReader(method.getBodyCode()));
        StringBuffer newMethodBody = new StringBuffer();
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            if (node == null) continue;
            ScriptHandler.postProcessContents(node, Modifier.isStatic(method.getModifiers()), fields);
            newMethodBody.append(node.getText());
        }
        return newMethodBody.toString();
    }

    public static String postProcessInitializers(String initializers, JavaField[] fields) {
        JavaParser p = new JavaParser(new StringReader(initializers));
        StringBuffer newInitializers = new StringBuffer();
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            if (node == null) continue;
            ScriptHandler.postProcessContents(node, false, fields);
            newInitializers.append(node.getText());
        }
        return newInitializers.toString();
    }

    private static void postProcessContents(SimpleNode node, boolean staticContext, JavaField[] fields) {
        if (node.getId() == 22) {
            if (node.getParent().getChild(0).getText().indexOf("static") != -1) {
                staticContext = true;
            }
        } else if (node.getId() == 28 && node.getText().trim().startsWith("static")) {
            staticContext = true;
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            ScriptHandler.postProcessContents(node.getChild(i), staticContext, fields);
        }
        int id = node.getId();
        if (!staticContext) {
            String lhs = null;
            if (id == 41 || id == 59 && node.jjtGetNumChildren() == 2) {
                lhs = ((SimpleNode)node.jjtGetChild(0)).getText().trim();
            } else if (id == 55 || id == 56) {
                lhs = ((SimpleNode)node.jjtGetChild(0)).getText().trim();
            }
            if (lhs != null) {
                for (JavaField field : fields) {
                    if (!field.getName().equals(lhs)) continue;
                    node.firstToken.image = String.format(SWING_POSTPROCESS_FIRST_TOKEN_PATTERN, field.getType(), node.firstToken.image);
                    node.lastToken.image = String.format(SWING_POSTPROCESS_LAST_TOKEN_PATTERN, node.lastToken.image, lhs);
                }
            }
        }
    }

    private static Map<ScriptPart, Object> analyseScriptNode(SimpleNode node) {
        String text;
        ArrayList<String> imports = new ArrayList<String>();
        ArrayList<JavaMethod> methods = new ArrayList<JavaMethod>();
        ArrayList<JavaField> fields = new ArrayList<JavaField>();
        StringBuffer bodyCode = new StringBuffer();
        StringBuffer initializers = new StringBuffer();
        int nodeType = ScriptHandler.getLineType(node);
        if (nodeType == 3) {
            text = node.getChild(0).getText().trim();
            if (text.startsWith("import")) {
                text = text.substring("import".length()).trim();
            }
            if (text.endsWith(";")) {
                text = text.substring(0, text.length() - 1);
            }
            imports.add(text);
        } else if (nodeType == 9) {
            bodyCode.append(node.getChild(0).getText().trim()).append("\n");
        } else if (nodeType == 22) {
            String returnType = null;
            String name = null;
            ArrayList<JavaArgument> parameterTypes = new ArrayList<JavaArgument>();
            ArrayList<String> exceptionTypes = new ArrayList<String>();
            String block = null;
            String javaDoc = ScriptHandler.getJavaDoc(node.getChild(0).getChild(0));
            int modifier = ScriptHandler.getModifier(node.getChild(0).getChild(0));
            SimpleNode methodDeclaration = node.getChild(0).getChild(1);
            assert (methodDeclaration.getId() == 22);
            for (int i = 0; i < methodDeclaration.jjtGetNumChildren(); ++i) {
                SimpleNode child = methodDeclaration.getChild(i);
                int type = child.getId();
                if (type == 36) {
                    returnType = child.getText().trim();
                    continue;
                }
                if (type == 23) {
                    name = child.firstToken.image.trim();
                    SimpleNode formalParameters = child.getChild(0);
                    assert (formalParameters.getId() == 24);
                    for (int j = 0; j < formalParameters.jjtGetNumChildren(); ++j) {
                        SimpleNode parameter = formalParameters.getChild(j);
                        String parameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                        String parameterName = parameter.getChild(2).getText().trim();
                        parameterTypes.add(new JavaArgument(parameterType, parameterName));
                    }
                    continue;
                }
                if (type == 38) {
                    for (int j = 0; j < child.jjtGetNumChildren(); ++j) {
                        SimpleNode exception = child.getChild(j);
                        String exceptionType = exception.getText().trim();
                        exceptionTypes.add(exceptionType);
                    }
                    continue;
                }
                if (type != 76) continue;
                Pattern p = Pattern.compile("[\\s]*\\{(.*)\\}[\\s]*", 32);
                Matcher m = p.matcher(child.getText());
                block = m.matches() ? m.group(1) : null;
            }
            JavaMethod method = new JavaMethod(modifier, returnType, name, parameterTypes.isEmpty() ? null : parameterTypes.toArray(new JavaArgument[parameterTypes.size()]), exceptionTypes.toArray(new String[exceptionTypes.size()]), block, javaDoc);
            methods.add(method);
        } else if (nodeType == 6 || nodeType == 28) {
            String str = node.getText().trim();
            if (!str.endsWith(";")) {
                str = str + ";";
            }
            bodyCode.append(str).append("\n");
        } else if (nodeType == 26) {
            bodyCode.append(ScriptHandler.processConstructor(node.getChild(0).getChild(0).getText(), node.getChild(0).getChild(1)));
        } else if (nodeType == 78 || nodeType == 17) {
            SimpleNode fieldDeclaration = node.getChild(0).getChild(0);
            String fieldClass = null;
            String fieldName = null;
            String fieldInit = null;
            int fieldModifier = 4;
            for (int i = 0; i < fieldDeclaration.jjtGetNumChildren(); ++i) {
                SimpleNode child = fieldDeclaration.getChild(i);
                int type = child.getId();
                if (type == 4) {
                    fieldModifier = ScriptHandler.getModifier(child);
                    continue;
                }
                if (type == 18) {
                    fieldName = child.getChild(0).getText().trim();
                    if (child.jjtGetNumChildren() <= 1) continue;
                    fieldInit = child.getChild(1).getText().trim();
                    continue;
                }
                if (type != 29) continue;
                fieldClass = child.getChild(0).getText().trim();
            }
            if (fieldInit != null) {
                initializers.append(fieldName).append(" = ").append(fieldInit).append(";\n");
            }
            JavaField field = new JavaField(fieldModifier, fieldClass, fieldName, null, TagManager.getGuixClassHandler(fieldClass));
            fields.add(field);
        } else {
            text = node.getText().trim();
            if (text.length() > 0) {
                if (!text.endsWith(";")) {
                    text = text + ";";
                }
                initializers.append(text);
            }
        }
        HashMap<ScriptPart, Object> result = new HashMap<ScriptPart, Object>();
        result.put(ScriptPart.IMPORTS, imports);
        result.put(ScriptPart.BODYCODE, bodyCode.toString());
        result.put(ScriptPart.INITIALIZERS, initializers.toString());
        result.put(ScriptPart.METHODS, methods);
        result.put(ScriptPart.FIELDS, fields);
        return result;
    }

    private static int getLineType(SimpleNode line) {
        if (line.jjtGetNumChildren() == 1) {
            SimpleNode node = line.getChild(0);
            if (node.getId() == 77) {
                if (node.jjtGetNumChildren() == 1) {
                    return node.getChild(0).getId();
                }
            } else if (node.getId() == 16) {
                int id = node.getChild(0).getId();
                if (id == 4) {
                    return node.getChild(1).getId();
                }
                if (id == 28) {
                    return id;
                }
            }
            return node.getId();
        }
        return 0;
    }

    private static String processConstructor(String modifiers, SimpleNode node) {
        assert (node.getId() == 26) : "expected node to be ConstructorDeclaration, found " + JavaParserTreeConstants.jjtNodeName[node.getId()] + " instead";
        assert (node.getChild(0).getId() == 24) : "expected node 0 to be FormalParameters, found " + JavaParserTreeConstants.jjtNodeName[node.getChild(1).getId()] + " instead";
        String code = "";
        if (node.getChild(0).jjtGetNumChildren() == 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)"The default no-argument constructor may not be redefined");
            }
        } else {
            SimpleNode explicitConstructorInvocation = ScriptHandler.findExplicitConstructorInvocation(node);
            if (explicitConstructorInvocation == null || explicitConstructorInvocation.getText().trim().startsWith("super(")) {
                code = "initialize();\n";
                if (explicitConstructorInvocation == null) {
                    node.getChild((int)1).firstToken.image = node.getChild((int)1).firstToken.image;
                } else {
                    explicitConstructorInvocation.lastToken.image = explicitConstructorInvocation.lastToken.image + code;
                }
            }
        }
        return modifiers + " " + node.getText().substring(0, node.getText().length() - 1) + code + "}";
    }

    private static SimpleNode findExplicitConstructorInvocation(SimpleNode parent) {
        if (parent.getId() == 27) {
            return parent;
        }
        int count = parent.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            SimpleNode result = ScriptHandler.findExplicitConstructorInvocation(parent.getChild(i));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static String getJavaDoc(SimpleNode node) {
        Pattern p = Pattern.compile(".*/\\*\\*(.*)\\*/.*", 32);
        Matcher m = p.matcher(node.getText());
        return m.matches() ? m.group(1).replace("*", "") : null;
    }

    private static int getModifier(SimpleNode node) {
        String modifier;
        int result = 4;
        Pattern p = Pattern.compile(".*(/\\*\\*(.*)\\*/).*", 32);
        Matcher m = p.matcher(node.getText());
        String string = modifier = m.matches() ? node.getText().replace(m.group(1), "") : node.getText();
        if (modifier.contains("public")) {
            int n = result = result == 4 ? 1 : result | 1;
        }
        if (modifier.contains("private")) {
            int n = result = result == 4 ? 2 : result | 2;
        }
        if (modifier.contains("protected")) {
            int n = result = result == 4 ? 4 : result | 4;
        }
        if (modifier.contains("static")) {
            int n = result = result == 4 ? 8 : result | 8;
        }
        if (modifier.contains("final")) {
            result = result == 4 ? 16 : result | 0x10;
        }
        return result;
    }

    public static enum ScriptPart {
        IMPORTS,
        BODYCODE,
        INITIALIZERS,
        METHODS,
        FIELDS;

    }
}

