/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.BindingUtils;
import org.nuiton.guix.GuixCompiler;
import org.nuiton.guix.generator.GuixGenerator;
import org.nuiton.guix.generator.JavaArgument;
import org.nuiton.guix.generator.JavaField;
import org.nuiton.guix.generator.JavaFile;
import org.nuiton.guix.generator.JavaMethod;
import org.nuiton.guix.model.ClassDescriptor;
import org.nuiton.guix.model.GuixModelObject;
import org.nuiton.guix.parser.JavaParser;
import org.nuiton.guix.parser.SimpleNode;
import org.nuiton.guix.tags.TagManager;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class GuixLauncher {
    protected static final Log log = LogFactory.getLog(GuixLauncher.class);
    protected final File[] files;
    protected final List<String> classNames = new ArrayList<String>();
    protected List<File> guixFiles = new ArrayList<File>();
    protected List<String> guixFileClassNames = new ArrayList<String>();
    protected Map<GuixModelObject, Long> rootModelObjects = new HashMap<GuixModelObject, Long>();
    protected List<ClassDescriptor> classDescriptors = new ArrayList<ClassDescriptor>();
    private List<File> compiledFiles = new ArrayList<File>();
    private Map<GuixGenerator, JavaFile> generatedFiles = new HashMap<GuixGenerator, JavaFile>();
    private File srcDirectory;
    private File targetDirectory;
    private String mainClass;
    private Class<? extends GuixGenerator> generatorClass;
    private String generationLanguage;
    private String launcherName;
    private Map<ClassDescriptor, GuixModelObject> rootClassDescriptors = new HashMap<ClassDescriptor, GuixModelObject>();
    private Map<GuixModelObject, ArrayList<ClassDescriptor>> dependencies = new HashMap<GuixModelObject, ArrayList<ClassDescriptor>>();

    public GuixLauncher(File[] files, File targetDirectory, File srcDir, String mainClass, Class<? extends GuixGenerator> generatorClass, String generationLanguage, String launcherName) {
        this.files = files;
        this.srcDirectory = srcDir;
        this.targetDirectory = targetDirectory;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String path = files[i].getAbsolutePath();
                if (srcDir != null) {
                    this.classNames.add(path.substring(srcDir.getAbsolutePath().length() + 1, path.lastIndexOf(46)).replace(File.separatorChar, '.'));
                    continue;
                }
                this.classNames.add(path.substring(0, path.lastIndexOf(46)));
            }
        }
        this.mainClass = mainClass != null ? mainClass : "";
        this.launcherName = launcherName != null ? launcherName : "Main";
        this.generatorClass = generatorClass;
        this.generationLanguage = generationLanguage;
    }

    public File getSrcDirectory() {
        return this.srcDirectory;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public List<String> getGuixFileClassNames() {
        return this.guixFileClassNames;
    }

    public synchronized boolean compile() {
        if (this.files != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Start compiling");
            }
            this.guixFiles.addAll(Arrays.asList(this.files));
            this.guixFileClassNames.addAll(this.classNames);
            boolean success = true;
            try {
                assert (this.guixFiles.size() == this.guixFileClassNames.size());
                for (int i = 0; i < this.guixFiles.size(); ++i) {
                    File file = this.guixFiles.get(i);
                    String className = this.guixFileClassNames.get(i);
                    if (!this.compiledFiles.contains(file)) {
                        String classPackage;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Compiling class " + className));
                        }
                        this.compiledFiles.add(file);
                        if (this.targetDirectory != null) {
                            int dotPos = className.lastIndexOf(".");
                            classPackage = dotPos != -1 ? className.substring(0, dotPos) : "";
                        } else {
                            this.targetDirectory = file.getParentFile();
                            classPackage = this.targetDirectory.getAbsolutePath().replace(File.separatorChar, '.');
                        }
                        if (!this.targetDirectory.exists()) {
                            this.targetDirectory.mkdirs();
                        }
                        GuixCompiler compiler = new GuixCompiler(file, this, classPackage, this.generationLanguage);
                        GuixModelObject rootModelObject = compiler.compile();
                        this.addRootModelObject(rootModelObject, compiler.getLastModification());
                        if (!compiler.isFailed()) continue;
                        success = false;
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)(file.getName() + " has already been compiled."));
                }
                if (success) {
                    for (ClassDescriptor classDescriptor : this.classDescriptors) {
                        if (classDescriptor.getPackageName() != null || TagManager.getGuixClassHandler(classDescriptor.getName()) != null || !log.isWarnEnabled()) continue;
                        log.warn((Object)("The class '" + classDescriptor.getName() + "' has no package. Default package will be applied."));
                    }
                    if (this.generatorClass != null) {
                        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
                        XmlSerializer serializer = factory.newSerializer();
                        File config = new File(this.targetDirectory, "configSpring.xml");
                        serializer.setOutput((Writer)new PrintWriter(config));
                        serializer.startDocument("UTF-8", null);
                        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
                        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"\t");
                        serializer.text("\n");
                        serializer.docdecl(" beans SYSTEM \"http://www.springframework.org/dtd/spring-beans.dtd\"");
                        serializer.text("\n");
                        serializer.startTag("", "beans");
                        HashMap<String, JavaFile> classes = new HashMap<String, JavaFile>();
                        for (String c : this.classNames) {
                            classes.put(c, null);
                        }
                        ArrayList<GuixModelObject> rootMos = new ArrayList<GuixModelObject>();
                        for (GuixModelObject mo : this.rootModelObjects.keySet()) {
                            if (this.orderDependencies(mo, rootMos, this.rootClassDescriptors, -1)) continue;
                            log.error((Object)"I'm bad, I'm bad, you know it !");
                        }
                        for (GuixModelObject mo : rootMos) {
                            try {
                                GuixGenerator gen = this.generatorClass.newInstance();
                                gen.setSrcDir(this.srcDirectory);
                                gen.setDestDir(this.targetDirectory);
                                gen.setGmo(mo);
                                gen.setLastModification(this.rootModelObjects.get(mo));
                                gen.setMainClass((mo.getClassDescriptor().getPackageName() + "." + mo.getClassDescriptor().getName()).equals(this.mainClass));
                                gen.setSerializer(serializer);
                                gen.setClasses(classes);
                                gen.setLauncherName(this.launcherName);
                                gen.setCSSFiles(mo.getCssFiles());
                                JavaFile generatedFile = gen.generate();
                                if (generatedFile == null) continue;
                                this.generatedFiles.put(gen, generatedFile);
                                classes.put(mo.getClassDescriptor().toString(), generatedFile);
                            }
                            catch (InstantiationException eee) {
                                if (!log.isErrorEnabled()) continue;
                                log.error((Object)eee);
                            }
                            catch (IllegalAccessException eee) {
                                if (!log.isErrorEnabled()) continue;
                                log.error((Object)eee);
                            }
                        }
                        for (GuixGenerator gen : this.generatedFiles.keySet()) {
                            StringBuffer dbCreation = new StringBuffer();
                            StringBuffer dbDeletion = new StringBuffer();
                            StringBuffer dbProcess = new StringBuffer();
                            JavaFile jf = this.generatedFiles.get(gen);
                            for (String field : gen.getBindingsToGenerate().keySet()) {
                                for (String attr : gen.getBindingsToGenerate().get(field).keySet()) {
                                    try {
                                        dbCreation.append(dbCreation.length() != 0 ? "else if(\"" : "if(\"").append(field).append(".").append(attr).append("\".equals(_binding)) {\n");
                                        dbDeletion.append(dbDeletion.length() != 0 ? "else if(\"" : "if(\"").append(field).append(".").append(attr).append("\".equals(_binding)) {\n");
                                        dbProcess.append(dbProcess.length() != 0 ? "else if(\"" : "if(\"").append(field).append(".").append(attr).append("\".equals(_binding)) {\n");
                                        ArrayList<Class> listeners = new ArrayList<Class>();
                                        ArrayList<String[]> bindings = new ArrayList<String[]>();
                                        JavaParser p = new JavaParser(new StringReader(gen.getBindingsToGenerate().get(field).get(attr)));
                                        while (!p.Line()) {
                                            List<String[]> l;
                                            SimpleNode node = p.popNode();
                                            if (node == null || (l = BindingUtils.scanNode(node)) == null) continue;
                                            bindings.addAll(l);
                                        }
                                        for (String[] binding : bindings) {
                                            StringBuffer methodToInvoke = new StringBuffer();
                                            StringBuffer oldBinding = new StringBuffer();
                                            for (String s : binding) {
                                                methodToInvoke.append(s.replaceAll("\\W", ""));
                                                oldBinding.append(s).append(".");
                                            }
                                            oldBinding.setLength(oldBinding.length() - 1);
                                            listeners.addAll(gen.generateBindings(dbCreation, dbDeletion, null, jf, null, binding, 0, null, methodToInvoke.toString(), this.generatedFiles));
                                            StringBuffer newBinding = new StringBuffer();
                                            for (String s : binding) {
                                                newBinding.append(s).append(".");
                                            }
                                            newBinding.setLength(newBinding.length() - 1);
                                            gen.getBindingsToGenerate().get(field).put(attr, gen.getBindingsToGenerate().get(field).get(attr).replace(oldBinding.toString(), newBinding.toString()));
                                            if (jf.getMethod("onChangeFrom" + methodToInvoke, null) == null) {
                                                jf.addMethod(new JavaMethod(1, "void", "onChangeFrom" + methodToInvoke.toString(), null, null, "processDataBinding(\"" + field + "." + attr + "\");", "Method called when the objects bound by '" + attr + "' of '" + field + "' change"));
                                                continue;
                                            }
                                            jf.getMethod("onChangeFrom" + methodToInvoke.toString(), null).appendBodyCode("processDataBinding(\"" + field + "." + attr + "\");", "\n");
                                        }
                                        dbCreation.append("}\n");
                                        dbDeletion.append("}\n");
                                        dbProcess.append(field).append(".set").append(Character.toUpperCase(attr.charAt(0))).append(attr.substring(1)).append("(").append(gen.getBindingsToGenerate().get(field).get(attr)).append(");\n}\n");
                                        if (listeners == null) continue;
                                        jf.getMethod("initDataBinding", null).appendBodyCode("applyDataBinding(\"" + field + "." + attr + "\");", "\n");
                                    }
                                    catch (NullPointerException eee) {
                                        dbCreation.append("}\n");
                                        dbDeletion.append("}\n");
                                        dbProcess.append("}\n");
                                    }
                                }
                            }
                            if (this.generatedFiles.get(jf.getSuperClass()) != null) {
                                dbCreation.append("else {\nsuper.applyDataBinding(_binding);\nreturn;\n}");
                                dbDeletion.append("\nelse {\nsuper.removeDataBinding(_binding);\n}\n");
                            }
                            dbCreation.append("\nprocessDataBinding(_binding);");
                            dbProcess.insert(0, "if (activeBindings.contains(_binding)) {\nreturn;\n}\nactiveBindings.add(_binding);\ntry{\n");
                            dbProcess.append("\n} finally {\nactiveBindings.remove(_binding);\n}\n");
                            if (!jf.isSuperclassIsGuixObject()) {
                                jf.addSimpleField(new JavaField(4, "java.util.List<String>", "activeBindings", "new java.util.ArrayList<String>()", "List of the active bindings", null));
                            }
                            jf.addMethod(new JavaMethod(1, "void", "applyDataBinding", new JavaArgument[]{new JavaArgument("String", "_binding")}, null, (jf.isSuperclassIsGuixObject() ? "super.applyDataBinding(_binding);\n" : "") + dbCreation.toString(), "Adds the listeners to the elements which are bound by another attribute"));
                            jf.addMethod(new JavaMethod(1, "void", "processDataBinding", new JavaArgument[]{new JavaArgument("String", "_binding")}, null, (jf.isSuperclassIsGuixObject() ? "super.processDataBinding(_binding);\n" : "") + dbProcess.toString(), "Executes the binding instruction"));
                            gen.saveFiles();
                        }
                        serializer.endTag("", "beans");
                        serializer.endDocument();
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)"No generation language given");
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
            return success;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)"No file to compile");
        }
        return true;
    }

    public ClassDescriptor registerClassDescriptor(ClassDescriptor classDescriptor) {
        int i;
        if (classDescriptor == null || classDescriptor.getName() == null) {
            return null;
        }
        for (i = 0; i < this.classDescriptors.size() && (!this.classDescriptors.get(i).getName().equals(classDescriptor.getName()) || this.classDescriptors.get(i).getPackageName() != null && classDescriptor.getPackageName() != null && !this.classDescriptors.get(i).getPackageName().equals(classDescriptor.getPackageName())); ++i) {
        }
        if (i >= this.classDescriptors.size()) {
            ClassDescriptor cd = this.registerClassDescriptor(classDescriptor.getSuperClass());
            classDescriptor.setSuperClass(cd);
            this.classDescriptors.add(classDescriptor);
            if (log.isDebugEnabled()) {
                log.debug((Object)("new ClassDescriptor " + classDescriptor + " inserted"));
            }
            return classDescriptor;
        }
        if (classDescriptor.getPackageName() != null) {
            this.classDescriptors.get(i).setPackageName(classDescriptor.getPackageName());
        }
        if (classDescriptor.getScript() != null) {
            if (this.classDescriptors.get(i).getScript() == null) {
                this.classDescriptors.get(i).setScript(classDescriptor.getScript());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("add script to ClassDescriptor " + classDescriptor));
                }
            } else if (!this.classDescriptors.get(i).getScript().equals(classDescriptor.getScript())) {
                if (log.isDebugEnabled()) {
                    log.error((Object)("ClassDescriptor " + classDescriptor + " script already defined and different !"));
                }
                return null;
            }
        }
        if (classDescriptor.getSuperClass() != null) {
            ClassDescriptor cd = this.registerClassDescriptor(classDescriptor.getSuperClass());
            if (this.classDescriptors.get(i).getSuperClass() == null) {
                this.classDescriptors.get(i).setSuperClass(cd);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("add superclass to ClassDescriptor " + classDescriptor));
                }
            } else if (!this.classDescriptors.get(i).getSuperClass().equals(cd)) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("ClassDescriptor " + classDescriptor + " superclass already defined and different !"));
                }
                return null;
            }
        }
        return this.classDescriptors.get(i);
    }

    public void addRootModelObject(GuixModelObject gmo, Long l) {
        this.rootModelObjects.put(gmo, l);
        this.rootClassDescriptors.put(gmo.getClassDescriptor(), gmo);
    }

    public void addClassName(String className) {
        if (!this.classNames.contains(className)) {
            this.classNames.add(className);
        }
    }

    public void addCompiledFile(File f) {
        this.compiledFiles.add(f);
    }

    public boolean isFileAlreadyCompiled(File f) {
        return this.compiledFiles.contains(f);
    }

    public void addDependency(GuixModelObject gmo, ClassDescriptor cd) {
        if (!this.dependencies.containsKey(gmo)) {
            this.dependencies.put(gmo, new ArrayList());
        }
        if (!this.dependencies.get(gmo).contains(cd)) {
            this.dependencies.get(gmo).add(cd);
        }
    }

    private boolean orderDependencies(GuixModelObject mo, List<GuixModelObject> rootMos, Map<ClassDescriptor, GuixModelObject> rootCDs, int i) {
        if (!rootMos.contains(mo)) {
            if (this.dependencies.get(mo) != null) {
                for (ClassDescriptor cd : this.dependencies.get(mo)) {
                    if (rootCDs.get(cd) == null || rootMos.contains(rootCDs.get(cd)) || this.orderDependencies(rootCDs.get(cd), rootMos, rootCDs, -1)) continue;
                    return false;
                }
            }
            if (i < 0) {
                rootMos.add(mo);
            } else {
                rootMos.add(i, mo);
            }
        } else if (this.dependencies.get(mo) != null) {
            for (ClassDescriptor cd : this.dependencies.get(mo)) {
                if (!(rootCDs.get(cd) != null && !rootMos.contains(rootCDs.get(cd)) ? !this.orderDependencies(rootCDs.get(cd), rootMos, rootCDs, rootMos.indexOf(mo)) : rootCDs.get(cd) != null && rootMos.indexOf(mo) < rootMos.indexOf(rootCDs.get(cd)))) continue;
                return false;
            }
        }
        return true;
    }
}

