/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.stereotype.StereotypeDefinition;
import org.nuiton.eugene.models.stereotype.StereotypeDefinitionProvider;
import org.nuiton.eugene.models.stereotype.StereotypeDefinitionProviders;
import org.nuiton.eugene.models.tagvalue.TagValueDefinition;
import org.nuiton.eugene.models.tagvalue.TagValueDefinitionProvider;
import org.nuiton.eugene.models.tagvalue.TagValueDefinitionProviders;
import org.nuiton.eugene.writer.ChainedFileWriter;

@Mojo(name="available-data", requiresProject=true, requiresDirectInvocation=true, requiresDependencyResolution=ResolutionScope.TEST)
public class AvailableDataMojo
extends AbstractMojo {
    @Parameter(property="dataTypes", defaultValue="")
    protected String dataTypes;
    @Component(role=Model.class)
    protected Map<String, Model> modelTypes;
    @Component(role=ModelReader.class)
    protected Map<String, ModelReader<?>> modelReaders;
    @Component(role=Template.class)
    protected Map<String, Template<?>> modelTemplates;
    @Component(role=ChainedFileWriter.class)
    protected Map<String, ChainedFileWriter> writers;
    @Component(role=StereotypeDefinitionProvider.class)
    protected Map<String, StereotypeDefinitionProvider> stereotypeDefinitionProviders;
    @Component(role=TagValueDefinitionProvider.class)
    protected Map<String, TagValueDefinitionProvider> tagValueDefinitionProviders;
    protected Map<String, TagValueDefinitionProvider> loadedTagValueDefinitionProviders;
    protected Map<String, StereotypeDefinitionProvider> loadedStereotypeDefinitionProviders;
    protected TagValueDefinitionProvider currentTagValueDefinitionProvider;
    protected StereotypeDefinitionProvider currentStereotypeDefinitionProvider;

    public void execute() throws MojoExecutionException, MojoFailureException {
        EnumSet<AvailableData> safeDataTypes;
        StringBuilder buffer = new StringBuilder();
        String string = this.dataTypes = this.dataTypes == null ? "" : this.dataTypes.trim();
        if (StringUtils.isEmpty((CharSequence)this.dataTypes)) {
            safeDataTypes = EnumSet.allOf(AvailableData.class);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("will use all data types : " + safeDataTypes));
            }
        } else {
            safeDataTypes = EnumSet.noneOf(AvailableData.class);
            for (String s : this.dataTypes.split(",")) {
                s = s.trim().toLowerCase();
                try {
                    AvailableData data = AvailableData.valueOf(s);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("will use data type " + (Object)((Object)data)));
                    }
                    safeDataTypes.add(data);
                }
                catch (IllegalArgumentException e) {
                    this.getLog().warn((CharSequence)("does not know data type : " + s + " use one of " + Arrays.toString((Object[])AvailableData.values())));
                }
            }
        }
        if (safeDataTypes.contains((Object)AvailableData.stereotype)) {
            this.loadedStereotypeDefinitionProviders = new LinkedHashMap<String, StereotypeDefinitionProvider>();
            for (Map.Entry entry : this.stereotypeDefinitionProviders.entrySet()) {
                StereotypeDefinitionProvider provider = StereotypeDefinitionProviders.newProvider(Arrays.asList((StereotypeDefinitionProvider)entry.getValue()), (boolean)false);
                this.loadedStereotypeDefinitionProviders.put((String)entry.getKey(), provider);
            }
        }
        if (safeDataTypes.contains((Object)AvailableData.tagvalue)) {
            this.loadedTagValueDefinitionProviders = new LinkedHashMap<String, TagValueDefinitionProvider>();
            for (Map.Entry entry : this.tagValueDefinitionProviders.entrySet()) {
                TagValueDefinitionProvider provider = TagValueDefinitionProviders.newProvider(Arrays.asList((TagValueDefinitionProvider)entry.getValue()), (boolean)false);
                this.loadedTagValueDefinitionProviders.put((String)entry.getKey(), provider);
            }
        }
        for (AvailableData availableData : safeDataTypes) {
            buffer.append("\n");
            this.appendData(availableData, buffer);
        }
        this.getLog().info((CharSequence)("Get datas for data types : " + safeDataTypes + buffer.toString()));
    }

    protected void appendData(AvailableData data, StringBuilder buffer) {
        String dataType = data.name();
        if (data == AvailableData.tagvalue) {
            int nbData = 0;
            Iterator<TagValueDefinitionProvider> i$ = this.loadedTagValueDefinitionProviders.values().iterator();
            while (i$.hasNext()) {
                TagValueDefinitionProvider provider;
                this.currentTagValueDefinitionProvider = provider = i$.next();
                nbData += data.getData(this).size();
            }
            this.currentTagValueDefinitionProvider = null;
            String format = "\nFound %s %ss in %s provider(s) : %s\n";
            buffer.append(String.format(format, nbData, dataType, this.loadedTagValueDefinitionProviders.size(), this.loadedTagValueDefinitionProviders.keySet()));
            for (Map.Entry<String, TagValueDefinitionProvider> e : this.loadedTagValueDefinitionProviders.entrySet()) {
                TagValueDefinitionProvider provider;
                String providerName = e.getKey();
                this.currentTagValueDefinitionProvider = provider = e.getValue();
                Map<String, ?> map = data.getData(this);
                int size = map.size();
                buffer.append("\nProvider [").append(providerName).append("] - ");
                if (size == 0) {
                    buffer.append("No available ").append(dataType).append(".");
                } else if (size == 1) {
                    buffer.append("Found one ").append(dataType).append(" : ");
                } else {
                    buffer.append("Found ");
                    buffer.append(size);
                    buffer.append(" ");
                    buffer.append(dataType);
                    buffer.append("s : ");
                }
                for (Map.Entry<String, ?> e2 : map.entrySet()) {
                    data.toString(buffer, e2);
                }
            }
        } else if (data == AvailableData.stereotype) {
            int nbData = 0;
            Iterator<StereotypeDefinitionProvider> i$ = this.loadedStereotypeDefinitionProviders.values().iterator();
            while (i$.hasNext()) {
                StereotypeDefinitionProvider provider;
                this.currentStereotypeDefinitionProvider = provider = i$.next();
                nbData += data.getData(this).size();
            }
            this.currentStereotypeDefinitionProvider = null;
            String format = "\nFound %s %ss in %s provider(s) : %s\n";
            buffer.append(String.format(format, nbData, dataType, this.loadedStereotypeDefinitionProviders.size(), this.loadedStereotypeDefinitionProviders.keySet()));
            for (Map.Entry<String, StereotypeDefinitionProvider> e : this.loadedStereotypeDefinitionProviders.entrySet()) {
                StereotypeDefinitionProvider provider;
                String providerName = e.getKey();
                this.currentStereotypeDefinitionProvider = provider = e.getValue();
                Map<String, ?> map = data.getData(this);
                int size = map.size();
                buffer.append("\nProvider [").append(providerName).append("] - ");
                if (size == 0) {
                    buffer.append("No available ").append(dataType).append(".");
                } else if (size == 1) {
                    buffer.append("Found one ").append(dataType).append(" : ");
                } else {
                    buffer.append("Found ");
                    buffer.append(size);
                    buffer.append(" ");
                    buffer.append(dataType);
                    buffer.append("s : ");
                }
                for (Map.Entry<String, ?> e2 : map.entrySet()) {
                    data.toString(buffer, e2);
                }
            }
        } else {
            int size;
            Map<String, ?> map = data.getData(this);
            int n = size = map == null ? 0 : map.size();
            if (size == 0) {
                buffer.append("\nNo available ").append(dataType).append(".");
            } else {
                if (size == 1) {
                    buffer.append("\nFound one ").append(dataType).append(" : ");
                } else {
                    buffer.append("\nFound ");
                    buffer.append(size);
                    buffer.append(" ");
                    buffer.append(dataType);
                    buffer.append("s : ");
                }
                for (Map.Entry<String, ?> e : map.entrySet()) {
                    data.toString(buffer, e);
                }
            }
        }
    }

    public TagValueDefinitionProvider getCurrentTagValueDefinitionProvider() {
        return this.currentTagValueDefinitionProvider;
    }

    public StereotypeDefinitionProvider getCurrentStereotypeDefinitionProvider() {
        return this.currentStereotypeDefinitionProvider;
    }

    protected TagValueDefinitionProvider getTagValueDefinitionProvider() throws MojoExecutionException {
        TagValueDefinitionProvider provider = this.tagValueDefinitionProviders == null || this.tagValueDefinitionProviders.isEmpty() ? TagValueDefinitionProviders.newProvider((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (boolean)false) : TagValueDefinitionProviders.newProvider(this.tagValueDefinitionProviders.values(), (boolean)false);
        return provider;
    }

    protected StereotypeDefinitionProvider getStereotypeDefinitionProvider() throws MojoExecutionException {
        StereotypeDefinitionProvider provider = this.stereotypeDefinitionProviders == null || this.stereotypeDefinitionProviders.isEmpty() ? StereotypeDefinitionProviders.newProvider((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (boolean)false) : StereotypeDefinitionProviders.newProvider(this.stereotypeDefinitionProviders.values(), (boolean)false);
        return provider;
    }

    static enum AvailableData {
        modeltype{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelTypes;
            }
        }
        ,
        writer{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.writers;
            }

            @Override
            String toString(Object data) {
                ChainedFileWriter w = (ChainedFileWriter)data;
                StringBuilder b = new StringBuilder(super.toString(data));
                b.append("\n").append("  inputProtocol             : ");
                b.append(w.getInputProtocol());
                b.append("\n").append("  outputProtocol            : ");
                b.append(w.getOutputProtocol("objectmodel"));
                b.append("\n").append("  defaultIncludes           : ");
                b.append(w.getDefaultIncludes());
                b.append("\n").append("  defaultInputDirectory     : ");
                b.append(w.getDefaultInputDirectory());
                b.append("\n").append("  defaultTestInputDirectory : ");
                b.append(w.getDefaultTestInputDirectory());
                return b.toString();
            }
        }
        ,
        modelreader{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelReaders;
            }
        }
        ,
        modeltemplate{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelTemplates;
            }
        }
        ,
        tagvalue{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.getCurrentTagValueDefinitionProvider().getDefinition();
            }

            @Override
            String toString(Object data) {
                Class[] targets;
                TagValueDefinition d = (TagValueDefinition)data;
                StringBuilder sb = new StringBuilder();
                for (Class aClass : targets = d.target()) {
                    sb.append(", ").append(aClass.getSimpleName());
                }
                String result = sb.toString();
                if (targets.length > 0) {
                    result = result.substring(2);
                }
                return result;
            }

            @Override
            void toString(StringBuilder buffer, Map.Entry<String, ?> e) {
                String name = e.getKey();
                Object value = e.getValue();
                buffer.append("\n [");
                buffer.append(name);
                buffer.append("] targets : '");
                buffer.append(this.toString(value));
                buffer.append("' : ");
                buffer.append(((TagValueDefinition)value).documentation());
            }
        }
        ,
        stereotype{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.getCurrentStereotypeDefinitionProvider().getDefinition();
            }

            @Override
            String toString(Object data) {
                Class[] targets;
                StereotypeDefinition d = (StereotypeDefinition)data;
                StringBuilder sb = new StringBuilder();
                for (Class aClass : targets = d.target()) {
                    sb.append(", ").append(aClass.getSimpleName());
                }
                String result = sb.toString();
                if (targets.length > 0) {
                    result = result.substring(2);
                }
                return result;
            }

            @Override
            void toString(StringBuilder buffer, Map.Entry<String, ?> e) {
                String name = e.getKey();
                Object value = e.getValue();
                buffer.append("\n [");
                buffer.append(name);
                buffer.append("] targets : '");
                buffer.append(this.toString(value));
                buffer.append("' : ");
                buffer.append(((StereotypeDefinition)value).documentation());
            }
        };


        abstract Map<String, ?> getData(AvailableDataMojo var1);

        String toString(Object data) {
            return data.getClass().getName();
        }

        void toString(StringBuilder buffer, Map.Entry<String, ?> e) {
            String name = e.getKey();
            Object value = e.getValue();
            buffer.append("\n [");
            buffer.append(name);
            buffer.append("] with implementation '");
            buffer.append(this.toString(value));
            buffer.append('\'');
        }
    }
}

