package org.nuiton.eugene.plugin.renderer;

/*
 * #%L
 * EUGene :: Maven plugin
 * %%
 * Copyright (C) 2006 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.collections4.MapUtils;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.i18n.I18N;
import org.nuiton.eugene.models.tagvalue.TagValueDefinition;
import org.nuiton.eugene.models.tagvalue.TagValueDefinitionProvider;

import java.util.Locale;
import java.util.Map;

/**
 * Created on 5/31/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.10
 */
public class TagValuesReportRenderer extends AbstractEugeneReportRenderer<TagValueDefinitionProvider, TagValueDefinition> {

    public TagValuesReportRenderer(Sink sink,
                                   I18N i18n,
                                   Locale locale,
                                   String bundleName,
                                   String javaDocDestDir,
                                   String jxrDestDir,
                                   TagValueDefinitionProvider data) {
        super(sink, i18n, locale, bundleName, javaDocDestDir, jxrDestDir, data);
    }

    @Override
    protected Map<String, TagValueDefinition> getDataDetails() {
        return data.getDefinition();
    }

    @Override
    protected void renderSummaryTable(TagValueDefinitionProvider provider, Map<String, TagValueDefinition> details) {

        if (MapUtils.isEmpty(details)) {

            sink.text(getText("report.noTagValues"));

        } else {

            sink.section3();

            sink.sectionTitle3();
            sink.text(getText("report.summary.tagValues"));
            sink.sectionTitle3_();

            sink.lineBreak();


            sink.table();

            sink.tableRow();
            sinkHeaderCellText(getText("report.tagValue.name"));
            sinkHeaderCellText(getText("report.tagValue.description"));
            sink.tableRow_();

            for (Map.Entry<String, TagValueDefinition> entry : details.entrySet()) {

                String tagValueName = entry.getKey();
                TagValueDefinition tagValueDefinition = entry.getValue();

                sink.tableRow();
                sinkCellLink(tagValueName, "./" + bundleName + ".html#detail_" + tagValueName);
                sinkCellText(tagValueDefinition.documentation());
                sink.tableRow_();

            }

            sink.table_();

            sink.section3_();

        }

    }

    @Override
    protected void renderDetail(String key, TagValueDefinition detail) {

        sink.section2();
        sink.sectionTitle2();
        sink.anchor("detail_" + key);
        sink.text(getText("report.detail.tagValue.title") + "   " + key);
        sink.anchor_();
        sink.sectionTitle2_();

        sink.lineBreak();

        sink.table();

        sink.tableRow();
        sinkHeaderCellText(getText("report.detail.tagValue.name"));
        sinkCellText(key);
        sink.tableRow_();

        sink.tableRow();
        sinkHeaderCellText(getText("report.detail.tagValue.description"));
        sinkCellText(detail.documentation());
        sink.tableRow_();

        sink.tableRow();
        sinkHeaderCellText(getText("report.detail.tagValue.defaultValue"));
        sinkCellText(detail.defaultValue());
        sink.tableRow_();

        sink.tableRow();
        sinkHeaderCellText(getText("report.detail.tagValue.matcherClass"));
        sinkCellText(detail.matcherClass().getName());
        sink.tableRow_();

        sink.tableRow();
        sinkHeaderCellText(getText("report.detail.tagValue.target"));
        sink.tableCell();

        renderTargets(detail.target());

        sink.tableCell_();
        sink.tableRow_();

        sink.table_();

        sink.section3();
        sink.sectionTitle3();
        sink.text(getText("report.detail.tagValue.usage.title"));
        sink.sectionTitle3_();

        sink.text("//TODO Example of usage of this tag value");

        sink.section3_();

        sink.section2_();

    }

    @Override
    protected String getEugeneDocLink() {

        String url;

        if (locale.getCountry().equals(Locale.FRENCH.getCountry())) {
            url = "http://doc.nuiton.org/eugene/fr/eugene/tagValues.html";
        } else {
            url = "http://doc.nuiton.org/eugene/eugene/tagValues.html";
        }

        return url;

    }

}
