package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * $Id: JavaTemplatesGeneratorUtil.java 1388 2014-07-06 18:10:59Z tchemit $
 * $HeadURL: https://svn.nuiton.org/eugene/tags/eugene-2.12/eugene-java-templates/src/main/java/org/nuiton/eugene/java/JavaTemplatesGeneratorUtil.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelPackage;

/**
 * Utility class for pure java templates.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.5.6
 */
public class JavaTemplatesGeneratorUtil extends JavaGeneratorUtil {

    /**
     * Check if the given classifier has the
     * {@link JavaTemplatesStereoTypes#STEREOTYPE_BEAN} stereotype.
     *
     * @param classifier classifier to test
     * @return {@code true} if stereotype was found, {@code false otherwise}
     * @see JavaTemplatesStereoTypes#STEREOTYPE_BEAN
     * @deprecated since 2.9, use now {@link JavaTemplatesStereoTypes#hasBeanStereotype(ObjectModelClassifier, ObjectModelPackage)}
     */
    @Deprecated
    public static boolean hasBeanStereotype(ObjectModelClassifier classifier) {
        return JavaTemplatesStereoTypes.hasBeanStereotype(classifier, null);
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_NO_PCS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_NO_PCS
     * @since 2.3
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#isNoPCS(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    public static boolean isNoPCS(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_NO_PCS, classifier, model);
//        return value != null && "true".equals(value);
        boolean value = JavaTemplatesTagValues.isNoPCS(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_BEAN_SUPER_CLASS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_BEAN_SUPER_CLASS
     * @since 2.3
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getBeanSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getBeanSuperClassTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_BEAN_SUPER_CLASS, classifier, model);
        String value = JavaTemplatesTagValues.getBeanSuperClassTagValue(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_SUPER_CLASS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_SUPER_CLASS
     * @since 2.6.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getSimpleBeanSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getSimpleBeanSuperClassTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_SUPER_CLASS, classifier, model);
        String value = JavaTemplatesTagValues.getSimpleBeanSuperClassTagValue(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_INTERFACE}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_INTERFACE
     * @since 2.3
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#isSimpleBeanGenerateInterface(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static boolean isSimpleBeanGenerateInterface(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_GENERATE_INTERFACE, classifier, model);
//        return value != null && "true".equals(value);
        boolean value = JavaTemplatesTagValues.isSimpleBeanGenerateInterface(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_FACTORY}
     * tag value on the given model or classifier.
     *
     * @param model model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_FACTORY
     * @since 2.7.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#isSimpleBeanGenerateFactory(ObjectModel)}
     */
    @Deprecated
    public static boolean isSimpleBeanGenerateFactory(ObjectModel model) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_GENERATE_FACTORY, null, model);
//        return value != null && "true".equals(value);
        boolean value = JavaTemplatesTagValues.isSimpleBeanGenerateFactory(model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS
     * @since 2.6.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getSimpleBeanInterfaceSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getSimpleBeanInterfaceSuperClassTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_INTERFACE_SUPER_CLASS, classifier, model);
        String value = JavaTemplatesTagValues.getSimpleBeanInterfaceSuperClassTagValue(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX
     * @since 2.6.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getSimpleBeanClassNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getSimpleBeanClassNamePrefixTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_CLASS_NAME_PREFIX, classifier, model);
        String value = JavaTemplatesTagValues.getSimpleBeanClassNamePrefixTagValue(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX
     * @since 2.6.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getSimpleBeanClassNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getSimpleBeanClassNameSuffixTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_CLASS_NAME_SUFFIX, classifier, model);
        String value = JavaTemplatesTagValues.getSimpleBeanClassNameSuffixTagValue(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX
     * @since 2.6.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getSimpleBeanInterfaceNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getSimpleBeanInterfaceNamePrefixTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_INTERFACE_NAME_PREFIX, classifier, model);
        String value = JavaTemplatesTagValues.getSimpleBeanInterfaceNamePrefixTagValue(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX
     * @since 2.6.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getSimpleBeanInterfaceNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getSimpleBeanInterfaceNameSuffixTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_INTERFACE_NAME_SUFFIX, classifier, model);
        String value = JavaTemplatesTagValues.getSimpleBeanInterfaceNameSuffixTagValue(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_DEFAULTS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_GENERATE_DEFAULTS
     * @since 2.7.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#isSimpleBeanGenerateDefaults(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static boolean isSimpleBeanGenerateDefaults(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_GENERATE_DEFAULTS, classifier, model);
//        return value != null && "true".equals(value);
        boolean value = JavaTemplatesTagValues.isSimpleBeanGenerateDefaults(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_DEFAULTS_SUPER_CLASS}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_DEFAULTS_SUPER_CLASS
     * @since 2.7.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getSimpleBeanDefaultsSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getSimpleBeanDefaultsSuperClassTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_DEFAULTS_SUPER_CLASS, classifier, model);
        String value = JavaTemplatesTagValues.getSimpleBeanDefaultsSuperClassTagValue(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_PREFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_PREFIX
     * @since 2.7.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getSimpleBeanDefaultsClassNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getSimpleBeanDefaultsClassNamePrefixTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_PREFIX, classifier, model);
        String value = JavaTemplatesTagValues.getSimpleBeanDefaultsClassNamePrefixTagValue(classifier, aPackage, model);
        return value;
    }

    /**
     * Obtain the value of the {@link JavaTemplatesTagValues#TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_SUFFIX}
     * tag value on the given model or classifier.
     * <p/>
     * It will first look on the model, and then in the given classifier.
     * <p/>
     * <strong>If not filled, then use default {@code s} value.</strong>
     *
     * @param model      model to seek
     * @param classifier classifier to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see JavaTemplatesTagValues#TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_SUFFIX
     * @since 2.6.2
     * @deprecated since 2.9, use now {@link JavaTemplatesTagValues#getSimpleBeanDefaultsClassNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
     */
    @Deprecated
    public static String getSimpleBeanDefaultsClassNameSuffixTagValue(ObjectModel model, ObjectModelPackage aPackage, ObjectModelClassifier classifier) {
//        String value = findTagValue(JavaTemplatesTagValues.TAG_SIMPLE_BEAN_DEFAULTS_CLASS_NAME_SUFFIX, classifier, model);
        String value = JavaTemplatesTagValues.getSimpleBeanDefaultsClassNameSuffixTagValue(classifier, aPackage, model);
        return value;
    }
}
