/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.EugeneTagValues;
import org.nuiton.eugene.GeneratorException;
import org.nuiton.eugene.java.AbstractJavaBeanTransformer;
import org.nuiton.eugene.java.JavaTemplatesStereoTypes;
import org.nuiton.eugene.java.JavaTemplatesTagValues;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class SimpleJavaBeanTransformer
extends AbstractJavaBeanTransformer {
    private static final Log log = LogFactory.getLog(SimpleJavaBeanTransformer.class);

    public void transformFromModel(ObjectModel model) {
        String className = model.getName() + "BeanFactory";
        if (this.canGenerateFactory(model, className)) {
            this.generateBeanFactory(model, className);
        }
    }

    public void transformFromClass(ObjectModelClass input) {
        if (!JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)input)) {
            return;
        }
        String interfaceName = this.getBeanInterfaceName(input);
        String className = this.getBeanClassName(input);
        String defaultClassName = this.getBeanDefaultsClassName(input);
        boolean generateDefaults = this.canGenerateBeanDefaults(input);
        boolean generateInterface = this.canGenerateInterface(input, interfaceName);
        boolean generateClass = this.canGenerateBean(input, className);
        if (generateClass || generateInterface) {
            ObjectModelClass outputClass = this.generateBeanClass(input, className, interfaceName);
            if (generateInterface) {
                this.generateBeanInterface(input, interfaceName, outputClass);
                if (generateClass) {
                    for (ObjectModelOperation operation : this.getPublicOperations(outputClass)) {
                        this.addAnnotation((ObjectModelClassifier)outputClass, (ObjectModelElement)operation, Override.class);
                    }
                }
            }
            if (!generateClass) {
                this.builder.getModel().getClasses().remove(outputClass);
            }
        }
        if (generateDefaults) {
            this.generateBeanDefaults(input, defaultClassName);
        }
    }

    protected boolean canGenerateFactory(ObjectModel model, String className) {
        boolean generateFactory = JavaTemplatesTagValues.isSimpleBeanGenerateFactory(model);
        String defaultPackage = this.getDefaultPackageName();
        String fqn = defaultPackage + "." + className;
        boolean canGenerate = generateFactory && !this.isInClassPath(fqn);
        return canGenerate;
    }

    protected boolean canGenerateInterface(ObjectModelClass input, String className) {
        boolean canGenerate;
        boolean generateInterface = JavaTemplatesTagValues.isSimpleBeanGenerateInterface((ObjectModelClassifier)input, (ObjectModel)this.model);
        String fqn = input.getPackageName() + "." + className;
        boolean bl = canGenerate = generateInterface && !this.isInClassPath(fqn);
        if (canGenerate && !input.getOperations().isEmpty()) {
            throw new GeneratorException("Can't generate a simple bean interface as class " + fqn + " contains so operations." + "\nUse instead the JavaBeanTransformer.");
        }
        return canGenerate;
    }

    protected boolean canGenerateBean(ObjectModelClass input, String className) {
        boolean canGenerate;
        String fqn = input.getPackageName() + "." + className;
        boolean bl = canGenerate = !this.isInClassPath(fqn);
        if (canGenerate && !input.getOperations().isEmpty()) {
            throw new GeneratorException("Can't generate a simple bean as class " + fqn + " contains so operations." + "\nUse instead the JavaBeanTransformer.");
        }
        return canGenerate;
    }

    protected boolean canGenerateBeanDefaults(ObjectModelClass input) {
        boolean withInput = input != null;
        boolean canGenerate = JavaTemplatesTagValues.isSimpleBeanGenerateDefaults((ObjectModelClassifier)input, (ObjectModel)this.model);
        if (canGenerate && withInput) {
            canGenerate = !input.isAbstract() && JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)input);
        }
        return canGenerate;
    }

    protected boolean canGenerateBeanAbstractDefaults(ObjectModelClass input, String className) {
        String classPackage = input.getPackageName();
        String fqn = classPackage + "." + className;
        boolean canGenerate = !this.isInClassPath(fqn);
        return canGenerate;
    }

    protected void generateBeanFactory(ObjectModel model, String className) {
        String defaultPackage = this.getDefaultPackageName();
        ObjectModelClass output = this.createClass(className, defaultPackage);
        for (ObjectModelClass aClass : model.getClasses()) {
            if (aClass.isAbstract() || !JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)aClass)) continue;
            String packageName = aClass.getPackageName();
            String typeName = this.getBeanInterfaceName(aClass);
            String typeBeanName = this.getBeanClassName(aClass);
            this.addImport((ObjectModelClassifier)output, packageName + "." + typeName);
            this.addImport((ObjectModelClassifier)output, packageName + "." + typeBeanName);
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "typeOf" + typeName, "<BeanType extends " + typeName + "> Class<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return (Class<BeanType>) " + typeBeanName + ".class;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, typeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return new " + typeBeanName + "();\n" + "    ");
        }
    }

    protected ObjectModelInterface generateBeanInterface(ObjectModelClass input, String className, ObjectModelClass outputClass) {
        boolean serializableFound;
        ObjectModelInterface output = this.createInterface(className, input.getPackageName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        boolean superClassIsBean = false;
        String superClass = null;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)superclass)) {
                    superClassIsBean = true;
                    superClass = superclass.getPackageName() + "." + this.getBeanInterfaceName(superclass);
                    break;
                }
                superClass = superclass.getQualifiedName();
            }
        }
        if (superClass == null) {
            superClass = JavaTemplatesTagValues.getSimpleBeanInterfaceSuperClassTagValue((ObjectModelClassifier)input, (ObjectModel)this.model);
        }
        if ((serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, superClass)) || superClassIsBean) {
            this.addInterface((ObjectModelClassifier)output, Serializable.class);
        }
        this.generateI18nBlockAndConstants(input, (ObjectModelClassifier)output);
        for (ObjectModelOperation operation : this.getPublicOperations(outputClass)) {
            this.cloneOperation(operation, (ObjectModelClassifier)output, true, new ObjectModelJavaModifier[0]);
        }
        return output;
    }

    protected ObjectModelClass generateBeanClass(ObjectModelClass input, String className, String interfaceName) {
        boolean serializableFound;
        boolean generateInterface = interfaceName != null;
        String superClass = null;
        boolean superClassIsBean = false;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)superclass)) {
                    superClassIsBean = true;
                    superClass = this.getBeanClassName(superclass);
                    break;
                }
                superClass = superclass.getQualifiedName();
            }
        }
        if (!superClassIsBean && (superClass = JavaTemplatesTagValues.getSimpleBeanSuperClassTagValue((ObjectModelClassifier)input, (ObjectModel)this.model)) != null) {
            superClassIsBean = true;
        }
        ObjectModelClass output = input.isAbstract() ? this.createAbstractClass(className, input.getPackageName()) : this.createClass(className, input.getPackageName());
        if (superClass != null) {
            this.setSuperClass(output, superClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        if (generateInterface) {
            this.addInterface((ObjectModelClassifier)output, interfaceName);
            serializableFound = true;
        } else {
            serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, null);
            this.generateI18nBlockAndConstants(input, (ObjectModelClassifier)output);
        }
        this.addSerializable(input, output, serializableFound || superClassIsBean);
        List<ObjectModelAttribute> properties = this.getProperties(input);
        boolean usePCS = !JavaTemplatesTagValues.isNoPCS((ObjectModelClassifier)input, (ObjectModel)this.model);
        boolean generateBooleanGetMethods = !((EugeneTagValues)this.getTagValueDefinitionProvider(EugeneTagValues.class)).isDoNotGenerateBooleanGetMethods((ObjectModelClassifier)input, (ObjectModel)this.model);
        for (ObjectModelAttribute attr : properties) {
            this.createProperty(output, attr, usePCS, generateBooleanGetMethods);
        }
        if (!superClassIsBean) {
            this.addDefaultMethodForNoneBeanSuperClass(output, usePCS, properties);
        }
        return output;
    }

    protected void generateBeanDefaults(ObjectModelClass aClass, String defaultClassName) {
        boolean generateDefault = this.canGenerateBeanDefaults(aClass);
        if (!generateDefault) {
            return;
        }
        String packageName = aClass.getPackageName();
        String typeName = this.getBeanInterfaceName(aClass);
        String typeBeanName = this.getBeanClassName(aClass);
        String abstractoutclassName = "Abstract" + defaultClassName;
        if (!this.isInClassPath(packageName, defaultClassName)) {
            ObjectModelClass output = this.createClass(defaultClassName, packageName);
            this.setSuperClass(output, packageName + "." + abstractoutclassName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("will generate " + output.getQualifiedName()));
            }
        }
        if (!this.isInClassPath(packageName, abstractoutclassName)) {
            String superClassName = JavaTemplatesTagValues.getSimpleBeanDefaultsSuperClassTagValue((ObjectModelClassifier)aClass, (ObjectModel)this.model);
            ObjectModelClass output = this.createAbstractClass(abstractoutclassName, packageName);
            if (StringUtils.isNotBlank((CharSequence)superClassName)) {
                this.setSuperClass(output, superClassName);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("will generate " + output.getQualifiedName()));
            }
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "typeOf" + typeName, "<BeanType extends " + typeName + "> Class<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return (Class<BeanType>) " + typeBeanName + ".class;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, typeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return new " + typeBeanName + "();\n" + "    ");
            this.addImport((ObjectModelClassifier)output, Binder.class);
            this.addImport((ObjectModelClassifier)output, BinderFactory.class);
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "BeanType", "source");
            this.setOperationBody(operation, "\n        Class<BeanType> sourceType = typeOf" + typeName + "();\n" + "        Binder<BeanType,BeanType> binder = BinderFactory.newBinder(sourceType);\n" + "        BeanType result = new" + typeName + "(source, binder);\n" + "        return result;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "BeanType", "source");
            this.addParameter(operation, "Binder<BeanType, BeanType>", "binder");
            this.setOperationBody(operation, "\n        BeanType result = (BeanType) new" + typeName + "();\n" + "        binder.copy(source, result);\n" + "        return result;\n" + "    ");
        }
    }

    protected Collection<ObjectModelOperation> getPublicOperations(ObjectModelClass clazz) {
        ArrayList<ObjectModelOperation> result = new ArrayList<ObjectModelOperation>();
        for (ObjectModelOperation operation : clazz.getOperations()) {
            ObjectModelJavaModifier visibility = ObjectModelJavaModifier.fromVisibility((String)operation.getVisibility());
            if (ObjectModelJavaModifier.PUBLIC != visibility) continue;
            result.add(operation);
        }
        return result;
    }

    protected String getBeanInterfaceName(ObjectModelClass input) {
        String interfaceNamePrefix = JavaTemplatesTagValues.getSimpleBeanInterfaceNamePrefixTagValue((ObjectModelClassifier)input, (ObjectModel)this.model);
        String interfaceNameSuffix = JavaTemplatesTagValues.getSimpleBeanInterfaceNameSuffixTagValue((ObjectModelClassifier)input, (ObjectModel)this.model);
        return this.generateName(interfaceNamePrefix, input.getName(), interfaceNameSuffix);
    }

    protected String getBeanClassName(ObjectModelClass input) {
        String classNamePrefix = JavaTemplatesTagValues.getSimpleBeanClassNamePrefixTagValue((ObjectModelClassifier)input, (ObjectModel)this.model);
        String classNameSuffix = JavaTemplatesTagValues.getSimpleBeanClassNameSuffixTagValue((ObjectModelClassifier)input, (ObjectModel)this.model);
        return this.generateName(classNamePrefix, input.getName(), classNameSuffix);
    }

    protected String getBeanDefaultsClassName(ObjectModelClass input) {
        String classNamePrefix = JavaTemplatesTagValues.getSimpleBeanDefaultsClassNamePrefixTagValue((ObjectModelClassifier)input, (ObjectModel)this.model);
        String classNameSuffix = JavaTemplatesTagValues.getSimpleBeanDefaultsClassNameSuffixTagValue((ObjectModelClassifier)input, (ObjectModel)this.model);
        return this.generateName(classNamePrefix, input.getName(), classNameSuffix);
    }

    protected String generateName(String prefix, String name, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            sb.append(prefix);
        }
        sb.append(name);
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

