/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.Set;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

public class ThirdPartyJAXRSModule
implements ServerModule {
    private final Logger log = Logger.getLogger(ThirdPartyJAXRSModule.class);
    private final Configurator configurator;
    private final WebServer webServer;
    private Set<ThirdPartyJaxRsPackage> packages;

    public ThirdPartyJAXRSModule(WebServer webServer, Configurator configurator) {
        this.webServer = webServer;
        this.configurator = configurator;
    }

    @Override
    public void start(StringLogger logger) {
        this.packages = this.configurator.getThirdpartyJaxRsClasses();
        for (ThirdPartyJaxRsPackage tpp : this.packages) {
            this.webServer.addJAXRSPackages(JAXRSHelper.listFrom(new String[]{tpp.getPackageName()}), tpp.getMountPoint());
            this.log.info("Mounted third-party JAX-RS package [%s] at [%s]", tpp.getPackageName(), tpp.getMountPoint());
            if (logger == null) continue;
            logger.logMessage(String.format("Mounted third-party JAX-RS package [%s] at [%s]", tpp.getPackageName(), tpp.getMountPoint()));
        }
    }

    @Override
    public void stop() {
        if (this.packages != null) {
            for (ThirdPartyJaxRsPackage tpp : this.packages) {
                this.webServer.removeJAXRSPackages(JAXRSHelper.listFrom(new String[]{tpp.getPackageName()}), tpp.getMountPoint());
            }
        }
    }
}

