/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.expression;

import java.util.Map;
import java.util.WeakHashMap;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.scripting.component.Scriptable;

public abstract class AbstractScriptExpressionEvaluator
implements ExpressionEvaluator,
Disposable,
MuleContextAware {
    protected Map cache = new WeakHashMap(8);
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Object evaluate(String expression, MuleMessage message) {
        Scriptable script = this.getScript(expression);
        script.setMuleContext(this.muleContext);
        Bindings bindings = script.getScriptEngine().createBindings();
        script.populateBindings(bindings, message);
        try {
            Object object = script.runScript(bindings);
            return object;
        }
        catch (ScriptException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            bindings.clear();
        }
    }

    protected Scriptable getScript(String expression) {
        Scriptable script = (Scriptable)this.cache.get(expression);
        if (script == null) {
            script = new Scriptable(this.muleContext);
            script.setScriptEngineName(this.getName());
            script.setScriptText(expression);
            try {
                script.initialise();
            }
            catch (InitialisationException e) {
                throw new MuleRuntimeException(CoreMessages.initialisationFailure((String)"An error occurred initialising script."), (Throwable)e);
            }
            this.cache.put(expression, script);
        }
        return script;
    }

    public void dispose() {
        this.cache.clear();
    }
}

