/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.Map;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyWebXmlConfiguration
extends AbstractConfiguration {
    public static final String PROPERTY_THIS_WEB_INF_URL = "this.web-inf.url";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(WebAppContext context) throws Exception {
        Resource web_inf;
        if (context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("Configuring web-jetty.xml");
        }
        if ((web_inf = context.getWebInf()) != null && web_inf.isDirectory()) {
            Resource jetty = web_inf.addPath("jetty7-web.xml");
            if (!jetty.exists()) {
                jetty = web_inf.addPath("jetty-web.xml");
            }
            if (!jetty.exists()) {
                jetty = web_inf.addPath("web-jetty.xml");
            }
            if (jetty.exists()) {
                String[] old_server_classes = context.getServerClasses();
                try {
                    context.setServerClasses(null);
                    if (Log.isDebugEnabled()) {
                        Log.debug("Configure: " + jetty);
                    }
                    XmlConfiguration jetty_config = new XmlConfiguration(jetty.getURL());
                    this.setupXmlConfiguration(context, jetty_config, web_inf);
                    jetty_config.configure(context);
                }
                finally {
                    if (context.getServerClasses() == null) {
                        context.setServerClasses(old_server_classes);
                    }
                }
            }
        }
    }

    private void setupXmlConfiguration(WebAppContext context, XmlConfiguration jetty_config, Resource web_inf) {
        this.setupXmlConfiguration(jetty_config, web_inf);
    }

    private void setupXmlConfiguration(XmlConfiguration jetty_config, Resource web_inf) {
        Map<String, String> props = jetty_config.getProperties();
        props.put(PROPERTY_THIS_WEB_INF_URL, String.valueOf(web_inf.getURL()));
    }
}

