/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.mortbay.jetty.plus.annotation.Injection;
import org.mortbay.log.Log;

public class InjectionCollection {
    private HashMap fieldInjectionsMap = new HashMap();
    private HashMap methodInjectionsMap = new HashMap();

    public void add(Injection injection) {
        ArrayList<Injection> injections;
        if (injection == null || injection.getTarget() == null || injection.getTargetClass() == null) {
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Adding injection for class=" + injection.getTargetClass() + " on a " + injection.getTarget()));
        }
        HashMap injectionsMap = null;
        if (injection.getTarget() instanceof Field) {
            injectionsMap = this.fieldInjectionsMap;
        }
        if (injection.getTarget() instanceof Method) {
            injectionsMap = this.methodInjectionsMap;
        }
        if ((injections = (ArrayList<Injection>)injectionsMap.get(injection.getTargetClass())) == null) {
            injections = new ArrayList<Injection>();
            injectionsMap.put(injection.getTargetClass(), injections);
        }
        injections.add(injection);
    }

    public List getFieldInjections(Class clazz) {
        if (clazz == null) {
            return null;
        }
        List list = (List)this.fieldInjectionsMap.get(clazz);
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public List getMethodInjections(Class clazz) {
        if (clazz == null) {
            return null;
        }
        List list = (List)this.methodInjectionsMap.get(clazz);
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public List getInjections(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList results = new ArrayList();
        results.addAll(this.getFieldInjections(clazz));
        results.addAll(this.getMethodInjections(clazz));
        return results;
    }

    public Injection getInjection(Class clazz, Member member) {
        if (clazz == null) {
            return null;
        }
        if (member == null) {
            return null;
        }
        HashMap map = null;
        if (member instanceof Field) {
            map = this.fieldInjectionsMap;
        } else if (member instanceof Method) {
            map = this.methodInjectionsMap;
        }
        if (map == null) {
            return null;
        }
        List injections = (List)map.get(clazz);
        Injection injection = null;
        for (int i = 0; injections != null && i < injections.size() && injection == null; ++i) {
            Injection candidate = (Injection)injections.get(i);
            if (!candidate.getTarget().equals(member)) continue;
            injection = candidate;
        }
        return injection;
    }

    public void inject(Object injectable) throws Exception {
        int i;
        if (injectable == null) {
            return;
        }
        List list = this.getFieldInjections(injectable.getClass());
        for (i = 0; list != null && i < list.size(); ++i) {
            ((Injection)list.get(i)).inject(injectable);
        }
        list = this.getMethodInjections(injectable.getClass());
        for (i = 0; list != null && i < list.size(); ++i) {
            ((Injection)list.get(i)).inject(injectable);
        }
    }
}

