/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.mortbay.jetty.plugin.JettyServer;
import org.mortbay.jetty.plugin.JettyWebAppContext;

public class Starter {
    public static final String PORT_SYSPROPERTY = "jetty.port";
    private static final Logger LOG = Log.getLogger(Starter.class);
    private List<File> jettyXmls;
    private File contextXml;
    private JettyServer server;
    private JettyWebAppContext webApp;
    private int stopPort = 0;
    private String stopKey = null;
    private Properties props;
    private String token;

    public void configureJetty() throws Exception {
        HandlerCollection handlers;
        LOG.debug("Starting Jetty Server ...", new Object[0]);
        this.server = new JettyServer();
        this.applyJettyXml();
        Connector[] connectors = this.server.getConnectors();
        if (connectors == null || connectors.length == 0) {
            connectors = new Connector[]{this.server.createDefaultConnector(System.getProperty(PORT_SYSPROPERTY, null))};
            this.server.setConnectors(connectors);
        }
        if ((handlers = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class)) == null) {
            handlers = new HandlerCollection();
            this.server.setHandler((Handler)handlers);
        }
        this.server.configureHandlers();
        this.webApp = new JettyWebAppContext();
        this.configureWebApp();
        if (this.contextXml != null) {
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)this.contextXml));
            xmlConfiguration.getIdMap().put("Server", this.server);
            xmlConfiguration.configure((Object)this.webApp);
        }
        this.server.addWebApplication(this.webApp);
        System.err.println("STOP PORT=" + this.stopPort + ", STOP KEY=" + this.stopKey);
        if (this.stopPort > 0 && this.stopKey != null) {
            ShutdownMonitor monitor = ShutdownMonitor.getInstance();
            monitor.setPort(this.stopPort);
            monitor.setKey(this.stopKey);
            monitor.setExitVm(true);
        }
    }

    public void configureWebApp() throws Exception {
        int j;
        String[] names;
        if (this.props == null) {
            return;
        }
        String str = (String)this.props.get("context.path");
        if (str != null) {
            this.webApp.setContextPath(str);
        }
        if ((str = (String)this.props.get("web.xml")) != null) {
            this.webApp.setDescriptor(str);
        }
        if ((str = this.props.getProperty("tmp.dir")) != null) {
            this.webApp.setTempDirectory(new File(str.trim()));
        }
        if ((str = this.props.getProperty("base.dir")) != null && !"".equals(str.trim())) {
            this.webApp.setWar(str);
        }
        if ((str = this.props.getProperty("res.dirs")) != null && !"".equals(str.trim())) {
            ResourceCollection resources = new ResourceCollection(str);
            this.webApp.setBaseResource((Resource)resources);
        }
        if ((str = this.props.getProperty("overlay.files")) != null && !"".equals(str.trim())) {
            ArrayList<Resource> overlays = new ArrayList<Resource>();
            names = str.split(",");
            for (j = 0; names != null && j < names.length; ++j) {
                overlays.add(Resource.newResource((String)("jar:" + Resource.toURL((File)new File(names[j].trim())).toString() + "!/")));
            }
            this.webApp.setOverlays(overlays);
        }
        if ((str = this.props.getProperty("classes.dir")) != null && !"".equals(str.trim())) {
            this.webApp.setClasses(new File(str));
        }
        if ((str = this.props.getProperty("testClasses.dir")) != null && !"".equals(str.trim())) {
            this.webApp.setTestClasses(new File(str));
        }
        if ((str = this.props.getProperty("lib.jars")) != null && !"".equals(str.trim())) {
            ArrayList<File> jars = new ArrayList<File>();
            names = str.split(",");
            for (j = 0; names != null && j < names.length; ++j) {
                jars.add(new File(names[j].trim()));
            }
            this.webApp.setWebInfLib(jars);
        }
    }

    public void getConfiguration(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if ("--stop-port".equals(args[i])) {
                this.stopPort = Integer.parseInt(args[++i]);
            }
            if ("--stop-key".equals(args[i])) {
                this.stopKey = args[++i];
            }
            if ("--jetty-xml".equals(args[i])) {
                this.jettyXmls = new ArrayList<File>();
                String[] names = args[++i].split(",");
                for (int j = 0; names != null && j < names.length; ++j) {
                    this.jettyXmls.add(new File(names[j].trim()));
                }
            }
            if ("--context-xml".equals(args[i])) {
                this.contextXml = new File(args[++i]);
            }
            if ("--props".equals(args[i])) {
                File f = new File(args[++i].trim());
                this.props = new Properties();
                this.props.load(new FileInputStream(f));
            }
            if (!"--token".equals(args[i])) continue;
            this.token = args[++i].trim();
        }
    }

    public void run() throws Exception {
        LOG.info("Started Jetty Server", new Object[0]);
        this.server.start();
    }

    public void join() throws Exception {
        this.server.join();
    }

    public void communicateStartupResult(Exception e) {
        if (this.token != null) {
            if (e == null) {
                System.out.println(this.token);
            } else {
                System.out.println(this.token + "\t" + e.getMessage());
            }
        }
    }

    public void applyJettyXml() throws Exception {
        if (this.jettyXmls == null) {
            return;
        }
        for (File xmlFile : this.jettyXmls) {
            LOG.info("Configuring Jetty from xml configuration file = " + xmlFile.getCanonicalPath(), new Object[0]);
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)xmlFile));
            xmlConfiguration.configure((Object)this.server);
        }
    }

    protected void prependHandler(Handler handler, HandlerCollection handlers) {
        if (handler == null || handlers == null) {
            return;
        }
        Handler[] existing = handlers.getChildHandlers();
        Handler[] children = new Handler[existing.length + 1];
        children[0] = handler;
        System.arraycopy(existing, 0, children, 1, existing.length);
        handlers.setHandlers(children);
    }

    public static final void main(String[] args) {
        if (args == null) {
            System.exit(1);
        }
        Starter starter = null;
        try {
            starter = new Starter();
            starter.getConfiguration(args);
            starter.configureJetty();
            starter.run();
            starter.communicateStartupResult(null);
            starter.join();
        }
        catch (Exception e) {
            starter.communicateStartupResult(e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

