/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.mortbay.jetty.plugin.MavenAnnotationConfiguration;
import org.mortbay.jetty.plugin.MavenWebInfConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyWebAppContext
extends WebAppContext {
    private static final Logger LOG = Log.getLogger(JettyWebAppContext.class);
    private static final String DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN = ".*/javax.servlet-[^/]*\\.jar$|.*/servlet-api-[^/]*\\.jar$";
    private static final String WEB_INF_CLASSES_PREFIX = "/WEB-INF/classes";
    private static final String WEB_INF_LIB_PREFIX = "/WEB-INF/lib";
    private File classes = null;
    private File testClasses = null;
    private final List<File> webInfClasses = new ArrayList<File>();
    private final List<File> webInfJars = new ArrayList<File>();
    private final Map<String, File> webInfJarMap = new HashMap<String, File>();
    private final EnvConfiguration envConfig;
    private List<File> classpathFiles;
    private String jettyEnvXml;
    private List<Resource> overlays;
    private boolean unpackOverlays;
    private String containerIncludeJarPattern = null;
    private String webInfIncludeJarPattern = null;
    private boolean copyWebInf;
    private boolean baseAppFirst = true;

    public JettyWebAppContext() throws Exception {
        Configuration[] configurationArray = new Configuration[8];
        configurationArray[0] = new MavenWebInfConfiguration();
        configurationArray[1] = new WebXmlConfiguration();
        configurationArray[2] = new MetaInfConfiguration();
        configurationArray[3] = new FragmentConfiguration();
        this.envConfig = new EnvConfiguration();
        configurationArray[4] = this.envConfig;
        configurationArray[5] = new PlusConfiguration();
        configurationArray[6] = new MavenAnnotationConfiguration();
        configurationArray[7] = new JettyWebXmlConfiguration();
        this.setConfigurations(configurationArray);
        super.setCopyWebInf(false);
    }

    public void setContainerIncludeJarPattern(String pattern) {
        this.containerIncludeJarPattern = pattern;
    }

    public String getContainerIncludeJarPattern() {
        return this.containerIncludeJarPattern;
    }

    public String getWebInfIncludeJarPattern() {
        return this.webInfIncludeJarPattern;
    }

    public void setWebInfIncludeJarPattern(String pattern) {
        this.webInfIncludeJarPattern = pattern;
    }

    public boolean getUnpackOverlays() {
        return this.unpackOverlays;
    }

    public void setUnpackOverlays(boolean unpackOverlays) {
        this.unpackOverlays = unpackOverlays;
    }

    public List<File> getClassPathFiles() {
        return this.classpathFiles;
    }

    public void setOverlays(List<Resource> overlays) {
        this.overlays = overlays;
    }

    public List<Resource> getOverlays() {
        return this.overlays;
    }

    public void setJettyEnvXml(String jettyEnvXml) {
        this.jettyEnvXml = jettyEnvXml;
    }

    public String getJettyEnvXml() {
        return this.jettyEnvXml;
    }

    public void setClasses(File dir) {
        this.classes = dir;
    }

    public File getClasses() {
        return this.classes;
    }

    public void setWebInfLib(List<File> jars) {
        this.webInfJars.addAll(jars);
    }

    public void setTestClasses(File dir) {
        this.testClasses = dir;
    }

    public File getTestClasses() {
        return this.testClasses;
    }

    public void setCopyWebInf(boolean value) {
        this.copyWebInf = value;
    }

    public boolean isCopyWebInf() {
        return this.copyWebInf;
    }

    public void setBaseAppFirst(boolean value) {
        this.baseAppFirst = value;
    }

    public boolean getBaseAppFirst() {
        return this.baseAppFirst;
    }

    public void setResourceBases(String[] resourceBases) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String rl : resourceBases) {
            String[] rs;
            for (String r : rs = rl.split(" *, *")) {
                resources.add(r);
            }
        }
        this.setBaseResource((Resource)new ResourceCollection(resources.toArray(new String[resources.size()])));
    }

    public List<File> getWebInfLib() {
        return this.webInfJars;
    }

    public void doStart() throws Exception {
        String tmp = this.containerIncludeJarPattern;
        if (tmp == null || "".equals(tmp)) {
            tmp = (String)this.getAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern");
        }
        tmp = this.addPattern(tmp, DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN);
        this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", tmp);
        if (this.webInfIncludeJarPattern != null) {
            this.setAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern", this.webInfIncludeJarPattern);
        }
        if (this.testClasses != null) {
            this.webInfClasses.add(this.testClasses);
        }
        if (this.classes != null) {
            this.webInfClasses.add(this.classes);
        }
        this.classpathFiles = new ArrayList<File>();
        this.classpathFiles.addAll(this.webInfClasses);
        this.classpathFiles.addAll(this.webInfJars);
        this.webInfJarMap.clear();
        for (File file : this.webInfJars) {
            String fileName = file.getName();
            if (!fileName.endsWith(".jar")) continue;
            this.webInfJarMap.put(fileName, file);
        }
        if (this.jettyEnvXml != null) {
            this.envConfig.setJettyEnvXml(Resource.toURL((File)new File(this.jettyEnvXml)));
        }
        this.setShutdown(false);
        super.doStart();
    }

    public void doStop() throws Exception {
        if (this.classpathFiles != null) {
            this.classpathFiles.clear();
        }
        this.classpathFiles = null;
        this.classes = null;
        this.testClasses = null;
        if (this.webInfJarMap != null) {
            this.webInfJarMap.clear();
        }
        this.webInfClasses.clear();
        this.webInfJars.clear();
        this.setShutdown(true);
        Thread.currentThread();
        Thread.sleep(500L);
        super.doStop();
        this.setEventListeners(new EventListener[0]);
        this.getServletHandler().setFilters(new FilterHolder[0]);
        this.getServletHandler().setFilterMappings(new FilterMapping[0]);
        this.getServletHandler().setServlets(new ServletHolder[0]);
        this.getServletHandler().setServletMappings(new ServletMapping[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resource getResource(String uriInContext) throws MalformedURLException {
        Resource resource = null;
        resource = super.getResource(uriInContext);
        if (resource != null) {
            if (resource.exists()) return resource;
        }
        if (uriInContext == null) return resource;
        if (this.classes == null) return resource;
        String uri = URIUtil.canonicalPath((String)uriInContext);
        if (uri == null) {
            return null;
        }
        try {
            if (uri.startsWith(WEB_INF_CLASSES_PREFIX)) {
                if (uri.equalsIgnoreCase(WEB_INF_CLASSES_PREFIX) || uri.equalsIgnoreCase("/WEB-INF/classes/")) {
                    if (this.classes != null) {
                        return Resource.newResource((File)this.classes);
                    }
                    if (this.testClasses == null) return resource;
                    return Resource.newResource((File)this.testClasses);
                }
                Resource res = null;
                int i = 0;
                while (res == null) {
                    if (i >= this.webInfClasses.size()) return res;
                    String newPath = uri.replace(WEB_INF_CLASSES_PREFIX, this.webInfClasses.get(i).getPath());
                    res = Resource.newResource((String)newPath);
                    if (res.exists()) continue;
                    res = null;
                    ++i;
                }
                return res;
            }
            if (!uri.startsWith(WEB_INF_LIB_PREFIX)) return resource;
            String jarName = uri.replace(WEB_INF_LIB_PREFIX, "");
            if (jarName.startsWith("/") || jarName.startsWith("\\")) {
                jarName = jarName.substring(1);
            }
            if (jarName.length() == 0) {
                return null;
            }
            File jarFile = this.webInfJarMap.get(jarName);
            if (jarFile == null) return null;
            return Resource.newResource((String)jarFile.getPath());
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
        return resource;
    }

    public Set<String> getResourcePaths(String path) {
        Set paths = super.getResourcePaths(path);
        if (path != null) {
            TreeSet<String> allPaths = new TreeSet<String>();
            allPaths.addAll(paths);
            if (path.startsWith(WEB_INF_LIB_PREFIX)) {
                for (String fileName : this.webInfJarMap.keySet()) {
                    allPaths.add("/WEB-INF/lib/" + fileName);
                }
            } else if (path.startsWith(WEB_INF_CLASSES_PREFIX)) {
                for (int i = 0; i < this.webInfClasses.size(); ++i) {
                    String newPath = path.replace(WEB_INF_CLASSES_PREFIX, this.webInfClasses.get(i).getPath());
                    allPaths.addAll(super.getResourcePaths(newPath));
                }
            }
            return allPaths;
        }
        return paths;
    }

    public String addPattern(String s, String pattern) {
        if (!(s = s == null ? "" : s.trim()).contains(pattern)) {
            if (s.length() != 0) {
                s = s + "|";
            }
            s = s + pattern;
        }
        return s;
    }
}

