/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.keycloak.vault.VaultRawSecret;

public class SecretContains
extends TypeSafeMatcher<VaultRawSecret> {
    private String thisVaultAsString;

    public SecretContains(String thisVaultAsString) {
        this.thisVaultAsString = thisVaultAsString;
    }

    protected boolean matchesSafely(VaultRawSecret secret) {
        String convertedSecret = StandardCharsets.UTF_8.decode((ByteBuffer)secret.get().get()).toString();
        return this.thisVaultAsString.equals(convertedSecret);
    }

    public void describeTo(Description description) {
        description.appendText("is equal to " + this.thisVaultAsString);
    }

    public static Matcher<VaultRawSecret> secretContains(String thisVaultAsString) {
        return new SecretContains(thisVaultAsString);
    }
}

