/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resteasy;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.error.KcUnrecognizedPropertyExceptionHandler;
import org.keycloak.services.error.KeycloakErrorHandler;
import org.keycloak.services.error.KeycloakMismatchedInputExceptionHandler;
import org.keycloak.services.filters.KeycloakSecurityHeadersFilter;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.LoadBalancerResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.WelcomeResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resteasy.ResteasyKeycloakSessionFactory;
import org.keycloak.services.util.ObjectMapperResolver;

public class ResteasyKeycloakApplication
extends KeycloakApplication {
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();

    public ResteasyKeycloakApplication() {
        this.classes.add(RealmsResource.class);
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_API)) {
            this.classes.add(AdminRoot.class);
        }
        this.classes.add(ThemeResource.class);
        this.classes.add(KeycloakSecurityHeadersFilter.class);
        this.classes.add(KeycloakErrorHandler.class);
        this.classes.add(KcUnrecognizedPropertyExceptionHandler.class);
        this.classes.add(KeycloakMismatchedInputExceptionHandler.class);
        this.singletons.add(new ObjectMapperResolver());
        this.classes.add(WelcomeResource.class);
        if (MultiSiteUtils.isMultiSiteEnabled()) {
            this.classes.add(LoadBalancerResource.class);
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    protected KeycloakSessionFactory createSessionFactory() {
        ResteasyKeycloakSessionFactory factory = new ResteasyKeycloakSessionFactory();
        factory.init();
        return factory;
    }

    protected void createTemporaryAdmin(KeycloakSession session) {
    }
}

